/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.files

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.files.Types
import com.yakindu.sct.generator.cpp11.types.Cpp11Types
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * Generates the basic type definitions required for the C++11 code generator.
 * 
 * @author axel terfloth
 */
class SCTypes extends Types {

	@Inject protected extension CppNaming
	@Inject protected extension GenmodelEntries
	@Inject protected extension Cpp11Types


	override content(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations locations) '''
		«entry.licenseText»
		
		#ifndef «typesModule.define»_H_
		#define «typesModule.define»_H_
		
		/* As <cstdint> is not available on all platforms we choose to include <stdint.h>. You can switch to <cstdint> by commenting and uncommenting the lines below.*/
		// #include <cstdint>
		#include <stdint.h>
		
		#include <string>
		
		namespace sc {
				
		// typedef int_fast16_t   «sc_short.name»;
		typedef uint_fast16_t  «sc_ushort.name»;
		typedef int32_t        «sc_integer.name»;
		typedef int16_t		   «sc_error.name»;
		typedef double         «sc_real.name»;
		
		typedef «entry.getTimerServiceTimeType»       «sc_time.name»;
		
		typedef uint_fast16_t  «sc_eventid.name»;
		
		}
		
		#endif /* «typesModule.define»_H_ */
	'''
	
}