/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.providers.classdecl

import com.google.inject.Inject
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.providers.classdecl.InnerClassesProvider
import com.yakindu.sct.model.sexec.ExecutionFlow

/**
 * @author laszlo kovacs- Initial contribution.
 */
class Cpp11InnerClassesProvider extends InnerClassesProvider{
	
	@Inject protected extension IVariableCode
	@Inject protected extension Literals
	@Inject protected extension CppPointers
	@Inject protected extension CppSpecifiers
	
	override generateProperties(ExecutionFlow it)'''
		«FOR p : getProperties»
			«p.variableDeclarationCode»
		«ENDFOR»
	'''
	
	override generateInterfaces(ExecutionFlow it)'''
		«FOR s : namedInterfaces»
			«IF !s.members.nullOrEmpty»«s.interfaceName» «s.instance» {«s.interfaceName»«NULL_LITERAL.assignValue»};«ENDIF»
		«ENDFOR»
	'''
	
	override generateOCBInterfaces(ExecutionFlow it){
		if(entry.usePlainOperationCallbackPointers) super.generateOCBInterfaces(it)
		else '''
		«FOR s : getUnnamedInterfacesAndInternal»
			«IF s.hasOperations && !entry.useStaticOPC»«sharedPtr»«s.interfaceOCBName»«pointerType» «s.OCB_Instance» «NULL_LITERAL.assignValue»;«ENDIF»
		«ENDFOR»
		'''
	}
	
}