/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.submodules

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.core.extensions.EventQueueExtension
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.submodules.TimingFunctions
import com.yakindu.sct.generator.cpp11.codemodel.EventEnum
import com.yakindu.sct.generator.cpp11.codemodel.EventInstanceClasses
import com.yakindu.sct.generator.cpp11.codemodel.EventQueueImplementation
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*

/**
 * 
 * @author Lazlo Kovacs
 * @author Axel Terfloth
 */
class Cpp11TimingFunctions  extends TimingFunctions {
	
	@Inject protected extension EventQueue
	@Inject protected extension EventQueueImplementation
	@Inject protected extension EventInstanceClasses
	@Inject protected extension EventEnum
	@Inject protected extension Literals
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension EventQueueExtension
	@Inject protected GeneratorEntry entry
			
	
	override raiseTimeEventFunction(ExecutionFlow it) '''
		void «module»::«raiseTimeEventFctID»(«sc_eventid.fqName» evid)«IF !requiresIncomingEventQueue»«_noexcept»«ENDIF»
		{
			if (evid < «timeEventsCountConst»)
			{
				«IF requiresIncomingEventQueue»
					«incomingEventQueue.name».push_back(«createTimeEvent»);
				«ELSE»
					«flow.timeEventScope.instance»[evid] = true;
				«ENDIF»
				«IF isEventDriven» 
					«runCycleFctID»();
				«ENDIF»
			}
		}
	'''
	
	def protected createTimeEvent(ExecutionFlow it) {
		if (entry.usePlainPointers)
			'''new «eventInstanceClass»(static_cast<«eventEnum.asLiteral»>(evid + static_cast<«sc_integer.fqName»>(«timeEvents.head.enumerator.asLiteral»)))'''
		else
			'''«uniquePtr» «eventInstanceClass»«makeTypeCloser»(new «eventInstanceClass»(static_cast<«eventEnum.asLiteral»>(evid + static_cast<«sc_integer.fqName»>(«timeEvents.head.enumerator.asLiteral»))))'''
	}
	
	override timedStatemachineFunctionPrototypes(ExecutionFlow it) '''
		/*
		 * Functions inherited from TimedStatemachineInterface
		 */
		void «SET_TIMER_SERVICE»(«sharedPtr»«scTimerNS»::«timerInterface»«pointerType» «timerArgument»)«_noexcept»«_override»;
		
		«sharedPtr»«scTimerNS»::«timerInterface»«pointerType» «GET_TIMER_SERVICE»()«_noexcept»«_override»;
		
		void «raiseTimeEventFctID»(«sc_eventid.fqName» event)«IF !requiresIncomingEventQueue»«_noexcept»«ENDIF»«_override»;
		
		«sc_integer.fqName» «numTimeEventsFctID»()«_noexcept»«_override»;
		
	'''
	
	
}
