/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.types

import com.itemis.create.base.generator.core.types.Literals
import com.google.inject.Singleton

/**
 * The generated C++11 code uses literals which are different from those of the 
 * C++98 code generator.
 * 
 * @author axel terfloth - Initial contribution.
 */
@Singleton
class Cpp11Literals extends Literals {

	/** use <b>nullptr</b> keyword introduced with C++11 for <b>null</b> values */
	public static final String NULL_LITERAL_NAME = "nullptr";

	override NULL_LITERAL() {
		return NULL_LITERAL_NAME
	}
	
	public static final String SEPARATOR_TOKEN = "::";
	
	override ENUM_SEPARATOR() { SEPARATOR_TOKEN }
	
	override NAMESPACE_SEPARATOR() { SEPARATOR_TOKEN }
	
}
