/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.scxml.extensions

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.extensions.BaseStatementExtensions
import com.yakindu.sctunit.sCTUnit.AssertionStatement
import com.yakindu.sctunit.sCTUnit.LoopStatement
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement
import com.yakindu.base.types.Type

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class InterpreterStatementExtensions extends BaseStatementExtensions {

	@Inject extension InterpreterExpressionExtensions

	def dispatch CharSequence generate(AssertionStatement it) {
		'''assertTrue(«IF !errorMsg.nullOrEmpty»"«errorMsg»",«ENDIF»«expression.code»);'''
	}

	override dispatch CharSequence generate(VariableDefinitionStatement it) {
		if (definition.initialValue !==
			null) {
			'''«definition.type.java» «definition.name» = «IF isString»"«ENDIF»«definition.initialValue.code»«IF isString»"«ENDIF»;'''
		} else {
			'''«definition.type.java» «definition.name»;'''
		}
	}
	
	protected def boolean isString(VariableDefinitionStatement it) {
		definition.type.name.toLowerCase.equals('string')
	}

	def dispatch CharSequence generate(MockReturnStatement it) {
		'''Has to be implemented'''
	}

	def dispatch CharSequence generate(VerifyCalledStatement it) {
		'''Has to be implemented'''
	}

	def java(Type type) {
		switch type.name.toLowerCase {
			case 'integer': 'long'
			case 'boolean': 'boolean'
			case 'string': 'String'
			case 'real': 'double'
		}
	}

	override dispatch CharSequence generate(LoopStatement it) {
		'''
			while(«guard.code») {
				«FOR statement : body.code»
					«statement.generate»
				«ENDFOR»
			}
		'''
	}
}
