/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.scxml.qt.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Event
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Type
import com.yakindu.sct.generator.scxml.SCXMLNameProvider
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.extensions.BaseExpressionExtensions
import com.yakindu.sctunit.sCTUnit.EnterExpression
import com.yakindu.sctunit.sCTUnit.ExitExpression
import com.yakindu.sctunit.sCTUnit.ProceedExpression
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import com.yakindu.sctunit.sCTUnit.StatechartActiveExpression
import com.yakindu.sctunit.sCTUnit.StatechartFinalExpression
import com.yakindu.sctunit.sCTUnit.TriggerWithoutEventExpression
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

class QtExpressionExtensions extends BaseExpressionExtensions {

	@Inject extension QtNamingExtensions
	@Inject extension SCXMLNameProvider

	def dispatch CharSequence code(EnterExpression it) {
		'''enter(sm)'''
	}

	def dispatch CharSequence code(ExitExpression it) {
		'''exit(sm)'''
	}
	
	def dispatch code(TriggerWithoutEventExpression stm) {
		'''triggerWithoutEvent(sm)'''
	}

	override dispatch CharSequence code(EventRaisingExpression it) {
		'''raiseEvent(sm, "«event.getEvent.eventName»"«IF value !== null»«value.eventValue()»«ENDIF»)'''
	}

	def eventValue(Expression value) {
		val type = value.infer.type
		return if ("string".equals(type.name)) {
			''', QString::fromStdString(«value.code»)'''
		} else {
			''', QVariant::fromValue(«value.code»)'''
		}
	}

	override dispatch CharSequence code(ActiveStateReferenceExpression it) {
		'''isStateActive(sm, "«value.name»")'''
	}

	override dispatch CharSequence code(StatechartActiveExpression active) {
		'''isActive(sm)'''
	}

	override dispatch CharSequence code(StatechartFinalExpression stm) {
		'''isFinal(sm)'''
	}

	protected def dispatch Event getEvent(Expression it) {
		return null
	}

	protected def dispatch Event getEvent(ElementReferenceExpression it) {
		if (reference instanceof Event) {
			return reference as Event
		}
		return null
	}

	protected def dispatch Event getEvent(FeatureCall it) {
		if (feature instanceof Event) {
			return feature as Event
		}
		return null
	}

	override generateNotLocalElemRefExpr(ElementReferenceExpression it) {
		var type = reference.infer.type
		return '''«type.varGetter»(sm, "«variableName»")'''
	}

	override generateNotLocalAssignment(AssignmentExpression it) {
		var type = varRef.infer.type
		val container = EcoreUtil2.getContainerOfType(it, typeof(SCTUnitOperation))
		val context = container?.name + "#" + type.varSetter
		if (operator.name().equalsIgnoreCase("assign"))
			return '''«type.varSetter»(sm, "«varRef.variableName»", «expression.code», "«context»")'''
		else
			return '''«type.varSetter»(sm, "«varRef.variableName»", «varRef.code» «operator.toString» «expression.code»,  "«context»")'''
	}

	def CharSequence varSetter(Type type) {
		switch type.name.toLowerCase {
			case 'integer': '''setInteger'''
			case 'boolean': '''setBoolean'''
			case 'string': '''setString'''
			case 'real': '''setDouble'''
			default: '''unknown type'''
		}
	}

	def CharSequence varGetter(Type type) {
		switch type.name.toLowerCase {
			case 'integer': '''getInteger'''
			case 'boolean': '''getBoolean'''
			case 'string': '''getString'''
			case 'real': '''getDouble'''
			default: '''unknown type'''
		}
	}

	def dispatch CharSequence variableName(ElementReferenceExpression it) {
		'''«referenceName»'''
	}

	def dispatch CharSequence variableName(VariableDefinition it) {
		'''«type?.name»'''
	}

	def dispatch variableName(EObject it) {
		'''unknown type'''
	}

	override proceedTime(ProceedExpression it) {
		var Expression time_ms
		switch unit {
			case SECOND: time_ms = value.toMilliseconds(unit)
			case MILLISECOND: time_ms = value
			case MICROSECOND,
			case NANOSECOND,
			case CYCLES: return proceedCycles
		}
		'''proceedTime(«time_ms.code»);'''
	}

	override proceedCycles(ProceedExpression it) {
		'''runCycle();'''
	}

	override dispatch CharSequence code(FeatureCall call) {
		var type = call.feature.infer.type
		'''«type.varGetter»(sm, "«call.feature.fullyQualifiedName.toString("_")»")'''
	}

}
