/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.scxml.qt.extensions

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.extensions.BaseStatementExtensions
import com.yakindu.sctunit.sCTUnit.AssertionStatement
import com.yakindu.sctunit.sCTUnit.LoopStatement
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement
import com.yakindu.base.types.Type
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.base.expressions.expressions.LogicalRelationExpression
import com.yakindu.base.expressions.expressions.RelationalOperator
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class QtStatementExtensions extends BaseStatementExtensions {

	@Inject extension QtExpressionExtensions
	@Inject extension ICodegenTypeSystemAccess

	def dispatch CharSequence generate(AssertionStatement it) {
		switch (e : expression) {
			ActiveStateReferenceExpression: {
				'''assertStateActive(sm, "«(e as ActiveStateReferenceExpression).value.name»");'''
			}
			LogicalRelationExpression case e.operator == RelationalOperator.EQUALS: {
				'''QCOMPARE(«e.leftOperand.code», «e.rightOperand.code»);'''
			} default: {
				'''QVERIFY(«e.code»);'''
			}
		}
	}

	override dispatch CharSequence generate(VariableDefinitionStatement it) {
		if (definition.initialValue !== null) {
			'''«definition.type.targetLanguageName» «definition.name» = «definition.initialValue.code»;'''
		} else {
			'''«definition.type.targetLanguageName» «definition.name»;'''
		}
	}
	
	protected def boolean isString(VariableDefinitionStatement it) {
		definition.type.name.toLowerCase.equals('string')
	}

	def dispatch CharSequence generate(MockReturnStatement it) {
		'''Has to be implemented'''
	}

	def dispatch CharSequence generate(VerifyCalledStatement it) {
		'''Has to be implemented'''
	}

	def java(Type type) {
		switch type.name.toLowerCase {
			case 'integer': 'long'
			case 'boolean': 'boolean'
			case 'string': 'String'
			case 'real': 'double'
		}
	}

	override dispatch CharSequence generate(LoopStatement it) {
		'''
			while(«guard.code») {
				«FOR statement : body.code»
					«statement.generate»
				«ENDFOR»
			}
		'''
	}
}
