/**
 * Copyright (c) 2016 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Robert Rudi - itemis AG
 *  Robin Herrmann - itemis AG
 * 
 */

package com.yakindu.sctunit.generator.scxml.qt.files

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.generator.scxml.qt.extensions.QtNamingExtensions

class TestClassHeader extends TestClassSource{
	@Inject extension BaseNavigationExtensions
	@Inject extension QtNamingExtensions
	@Inject extension ICodegenTypeSystemAccess

	protected GeneratorEntry entry

	override filename(SCTUnitClass it) {
		'''QtSCTUnit/src/«testClassName.toLowerCase.h»'''.toString
	}
	override content(SCTUnitClass it) {
		'''
		#include <QtTest/QtTest>
					
		#include "abstractqtunittest.h"
		#include "«statechart.name».h"
		
		class «testClassName» : public AbstractQtUnitTest
		{
			Q_OBJECT
			
		public:
			
			«testClassName»(QObject* parent = 0) : AbstractQtUnitTest(parent),sm() {}
			~«testClassName»() {}
			
		private Q_SLOTS:
			«FOR operation : SCTUnitOperations.filter[isTest].filter[!ignore]»
				«operation.type.targetLanguageName» «operation.name»(«generateParameter(operation)»);
			«ENDFOR»
			
		private:
		
			QSharedPointer<«statechart.name»> sm;
			void init();
			«FOR operation : SCTUnitOperations.filter[!isTest]»
				«operation.type.targetLanguageName» «operation.name»(«generateParameter(operation)»);
			«ENDFOR»
		};
		'''
	}
}