/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Robert Rudi - itemis AG
 *  Robin Herrmann- itemis AG
 */
package com.yakindu.sctunit.generator.scxml.qt.files

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions
import org.eclipse.xtext.generator.IFileSystemAccess
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite
import com.yakindu.sctunit.sCTUnit.SCTUnitElement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.generator.scxml.qt.extensions.QtNamingExtensions

class TestRunner {
	@Inject extension BaseNavigationExtensions
	@Inject extension QtNamingExtensions
	
	
	def generate(GeneratorEntry entry, IFileSystemAccess fsa) {
		fsa.generateFile(filename(entry), content(entry))
	}
	
	def filename(GeneratorEntry entry) {
		return "QtSCTUnit/src/testrunner.cpp"
	}
	
	def content(GeneratorEntry entry) {
		val classes = entry.SCTUnitElement.getClasses
		'''
		#include <QtTest/QtTest>
		#include "abstractqtunittest.h"
		«FOR clazz : classes»
			#include "«clazz.testClassName.h.toLowerCase»"
		«ENDFOR»
		
		int main(int argc, char *argv[])
		{
		    «FOR clazz : classes»
		    	«clazz.testClassName» «clazz.testClassName.toFirstLower»;
		    «ENDFOR»
		    QCoreApplication a(argc, argv);

		
		    int status = 0;
		    auto test = [&status, argc, argv](QObject *obj) {
		        status |= QTest::qExec(obj, argc, argv);
		        if(status != 0)
		            QFAIL(QString("Error while executing tests in %1").arg(obj->objectName()).toStdString().c_str());
		    };
		
		    auto &suite = AbstractQtUnitTest::suite();
		    for (auto it = suite.begin(); it != suite.end(); ++it) {
		        test(*it);
		    }
		    return status;
		}
		'''
	}
	
	def getClasses(SCTUnitElement element) {
		if(element instanceof SCTUnitSuite){
			return element.SCTUnitClasses.toList
		}
		return newArrayList(element as SCTUnitClass)
	}
	
}