/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.sunit

import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Operation
import com.yakindu.base.types.AnnotatableElement

/**
 * Defines all SUnit annotation names and tests.
 *  
 * @author axel terfloth
 */
class SUnitAnnotations {

	public static String SUNIT_ANNOTATION = "__sunit__"
	
	public static String TEST_CLASS_ANNOTATION = "TestClass"
	public static String TEST_ANNOTATION = "Test"
	public static String IGNORE_ANNOTATION = "Ignore"
	
	def isTestClass(ComplexType it) {
		getAnnotationOfType(TEST_CLASS_ANNOTATION) !== null
	}
	
	def isSUnitTest(Operation it) {
		getAnnotationOfType(TEST_ANNOTATION) !== null
	}
	
	def isIgnoredTest(Operation it) {
		getAnnotationOfType(IGNORE_ANNOTATION) !== null
	}
	
	def isSUnit(AnnotatableElement it) {
		getAnnotationOfType(SUNIT_ANNOTATION) !== null
	}
	
	
}