/** 
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.itemis.create.sunit.generator.csharp.nunit.transformation

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.concepts.VirtualTimer
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.concepts.OutEventSubscriber
import com.itemis.create.base.generator.csharp.transformation.RaiseEventModification
import com.itemis.create.sunit.generator.csharp.nunit.codemodel.NUnitAnnotations
import com.itemis.create.sunit.generator.csharp.nunit.concepts.OutEventMembers
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.BlockExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Property
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil

/**
 * Transforms SCTUnit raise event expressions to codemodel based event raisers.
 * Also besides that supplement the test code with operation calls to "ClearOutEvents"
 * whenever a runCycle is completed or event is raised.
 *  
 * @author Laszlo Kovacs
 */
@Singleton
class NUnitRaiseEventModification extends RaiseEventModification{
	
	@Inject protected extension NUnitAnnotations
	@Inject protected extension IMethodCode
	@Inject protected extension GeneratorAssignment
	@Inject protected extension OutEventSubscriber
	@Inject protected extension OutEventMembers
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension ExpressionExtensions
	@Inject protected extension VirtualTimer
	@Inject protected extension Statechart2TypeTransformation
	
	override substituteEventRaisingExpressionsByEventRaisers(EObject it) {
		if(eAllContents.filter(AnnotatableElement).exists[isHandler])
			createClearOutEventMembers
		eAllContents
			.filter(EventRaisingExpression)
			.toList
			.forEach[ere |
				EcoreUtil.replace(ere, ere.raiser => [ raiser |
					if(clearOutEventMethod !== null && ere.eContainer instanceof BlockExpression){
						val container = (ere.eContainer as BlockExpression)
						container.expressions.add(container.expressions.indexOf(ere),clearOutEventMethod._call)
					}
				])
			]
		
		//In this case a runCycle has been performed, thus all outGoing events have to be cleared
		if(clearOutEventMethod !== null){
			eAllContents
			.filter(ArgumentExpression)
			.filter[it.featureOrReference !== null && (it.featureOrReference as NamedElement).name == cycleLeap]
			.forEach[cl |
				val container = (cl.eContainer as BlockExpression)
						container.expressions.add(container.expressions.indexOf(cl),clearOutEventMethod._call)
				]
		}		
			
		eAllContents
			.filter(EventValueReferenceExpression)
			.forEach[evre |
				EcoreUtil.replace(evre, (evre.value.featureOrReference.origin as EventDefinition).outEventValueMember._ref)
			]
	}
	
	def create o : _op("ClearOutEvents", _void) createClearOutEventMembers(EObject root){
		val testclass = root.eAllContents.filter(ComplexType).filter[isTestFixture].head
		o._private
		o.implementation = _block => [
			root.eAllContents.filter(Property).filter[origin instanceof EventDefinition].forEach[ p |
				expressions += _assignment(p._ref,_false)
			]
		]
		o.generateDefinitionWith[o.methodDefinitionCode]
		testclass.features +=o
	}
	
	def clearOutEventMethod(EObject it) {
		_createCache_createClearOutEventMembers.get(#[it])
	}
}