/** 
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.domain.java.generator

import com.yakindu.sct.generator.java.JavaIncludeProvider
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.ImportScope

/** 
 * @author Rene Beckmann - Initial API and contribution
 */
class JavaDomainIncludeProvider extends JavaIncludeProvider {

	override Iterable<String> getImports(ExecutionFlow it, GeneratorEntry entry) {
		val statechart = it.sourceElement as Statechart
		return statechart.scopes.filter(ImportScope).map[it.imports].flatten
	}
}
