/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.ui.labeling

import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider
import org.eclipse.xtext.resource.IEObjectDescription
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider
import com.yakindu.sct.model.sgraph.Statechart
import com.google.inject.Inject

/** 
 * Provides labels for a EObjects.
 * see http://www.eclipse.org/Xtext/documentation/latest/xtext.html#labelProvider
 */
class STextLabelProvider extends DefaultEObjectLabelProvider {
	@Inject new(AdapterFactoryLabelProvider delegate) {
		super(delegate)
	}

	// Labels and icons can be computed like this:
	def package String text(Statechart ele) {
		return ele.getName()
	}

	def package String text(IEObjectDescription ele) {
		return ele.getName().toString()
	}
	/*
	 * String image(MyModel ele) { return "MyModel.gif"; }
	 */

}
