/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.artifacts

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.artifacts.IContent
import com.itemis.create.base.generator.core.artifacts.IGenArtifact
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.yakindu.base.types.Package
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * Defines the artifact type of a C# file and implements the proper interface for integration into the CREATE code generator infrastructure.
 * 
 * @author Axel Terfloth
 */
class CSharpFile implements IContent, IGenArtifact {
	
	@Inject protected GeneratorEntry entry
	@Inject protected extension CsharpGenmodelEntries
	@Inject protected extension GeneratorAssignment
	
	
	protected Package compilationUnit
	

	def Package getCompilationUnit() {
		compilationUnit
	}

	def setCompilationUnit(Package cu) {
		compilationUnit = cu
	}
	
	
	def String fileName(Package it) '''«it.name».«IF entry.getgeneratedFileExtension»g.«ENDIF»cs'''
	
	def String fileName() { compilationUnit.fileName }
	
	
	override content() {
		'''
			«entry.licenseText»
			
			«entry.compilerPragma»

			«compilationUnit.definitionCode»
			
		'''
	}
	
	
}