/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.artifacts

import com.google.inject.Singleton
import com.itemis.create.base.generator.core.artifacts.IContent
import com.itemis.create.base.generator.core.artifacts.IGenArtifact

@Singleton
class CsharpITimed implements IContent, IGenArtifact {
		
	override content() '''
	public interface ITimed
	    {
	        /// <summary>
	        /// Callback method if a time event occurred.
	        /// </summary>
	        /// <param name="eventID">The id of the occurred event.</param>
	        void RaiseTimeEvent(long eventID);
	
	        /// <summary>
	        /// Set the ITimerService for the state machine. It must be set
	        /// externally on a timed state machine before Enter() is called.
	        /// </summary>
	        /// <param name="timerService">The timer service implementation to be set.</param>
	        void SetTimerService(ITimerService timerService);
	    }
	'''
}