/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.csharp.codepattern.CompilationUnitCode
import com.yakindu.base.types.Package
import com.yakindu.base.types.TypeBuilder

/**
 * Defines the code model concept of a C# compilation unit. A compilation unit is a collection of declarations
 * which should be placed in a single C# source file. A compilation unit model element is a Package which is annotated as 
 * compilation unit. This concept definition provides a builder to create a properly defined element including generator assignment
 * and a query to check if a package element represents a compilation unit. 
 * 
 * @author Axel Terfloth
 */
@Singleton
class CsharpCompilationUnit {

	@Inject protected extension TypeBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension CompilationUnitCode
	@Inject protected extension CsharpNamespace

	public static final String CSHARP_COMPILATION_UNIT = "__csharp_compilation_unit__"

	def _compilationUnit() {
		_package => [
			it._compilationUnit
		]
	}
	
	def _compilationUnit(String namespace) {
		_package => [
			it._compilationUnit(namespace)
		]
	}

	def _compilationUnit(Package it) {
		_no_namespace
		_annotate(CSHARP_COMPILATION_UNIT)
		generateDefinitionWith[compilationUnitCode]
	}
	
	def _compilationUnit(Package it, String namespace) {
		if(namespace === null)
			return it._compilationUnit
		_csNamespace
		name = namespace
		_annotate(CSHARP_COMPILATION_UNIT)
		generateDefinitionWith[compilationUnitCode]
	}

	def isCompilationUnit(Package it) {
		getAnnotationOfType(CSHARP_COMPILATION_UNIT) !== null
	}

}
