/**
 * Copyright (c) 2022-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility
import com.yakindu.base.types.ComplexType
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder

/**
 * @author laszlo kovacs - Initial contribution.
 */
class ClassCode {
	
	@Inject protected extension CsharpVisibility
	@Inject protected extension GeneratorAssignment
	@Inject protected extension AttributeCode
	@Inject protected extension Literals
	@Inject protected extension CsharpClass
	@Inject protected extension CsharpTypeBuilder
	
	def classCode(ComplexType it) '''
		«it.classDeclaration» {
			«FOR e : features.filter[declarationGenerator !== null || definitionGenerator !== null]»
			«IF e.declarationGenerator !== null»«e.declarationCode»«ENDIF»
			
			«IF e.definitionGenerator !== null»«e.definitionCode»«ENDIF»
			«ENDFOR»
		}'''
	
	def classDeclaration(ComplexType it) '''
		«it.attributeCode»
		«it.csharpVisibility» «signature» «it.name»«IF !genericTypes.nullOrEmpty»<«genericList»>«ENDIF»«IF !constrainedGenericTypes.nullOrEmpty»«constrainedList»«ELSEIF !regularSuperTypes.nullOrEmpty»:«regularList»«ENDIF»'''
	
	def protected regularSuperTypes(ComplexType it){
		superTypes.map[type].filter[!isGeneric_type].toList
	}
	
	def protected genericTypes(ComplexType it){
		superTypes.map[type].filter[isGeneric_type].toList
	}
	
	def protected constrainedGenericTypes(ComplexType it){
		genericTypes.filter[!superTypes.nullOrEmpty]
	}
	
	def protected constrainedList(ComplexType it)'''
	«FOR gt : constrainedGenericTypes SEPARATOR ", "» where «gt.asLiteral» : «FOR st : gt.superTypes.map[type] SEPARATOR ", "»«st.asLiteral»«ENDFOR»«ENDFOR»'''
	
	def protected genericList(ComplexType it)'''
	«FOR g : genericTypes SEPARATOR ", "»«g.asLiteral»«ENDFOR»'''
	
	def protected regularList(ComplexType it)'''
	«FOR i : superTypes SEPARATOR ", "»«i.type.asLiteral»«ENDFOR»'''
}
