/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codepattern

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpNamespace
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.yakindu.base.types.Package
import com.yakindu.base.types.Type
import com.yakindu.base.types.typesystem.ITypeSystem

import static com.yakindu.base.types.typesystem.ITypeSystem.INTEGER
import static com.yakindu.base.types.typesystem.ITypeSystem.STRING
import static com.yakindu.base.types.typesystem.ITypeSystem.VOID

/**
 * This extension class defines literal names for C#.
 * 
 * @author axel terfloth
 */
@Singleton
class CsharpLiterals extends Literals {
		
	public static final String NULL_LITERAL_NAME = "null";
	public static final String TRUE_LITERAL_NAME = "true";
	public static final String FALSE_LITERAL_NAME = "false";

	static String DOUBLE = "double"
	static String BOOL = "bool"
	static String LONG = "long"
	
	public static final String SEPARATOR_TOKEN = ".";
	
	@Inject	protected extension ITypeSystem
	@Inject	protected extension CsharpNamespace
	@Inject protected extension CsharpTypeBuilder

	override NULL_LITERAL(){ NULL_LITERAL_NAME }
	override TRUE_LITERAL(){ TRUE_LITERAL_NAME }
	override FALSE_LITERAL(){ FALSE_LITERAL_NAME }
	override ENUM_SEPARATOR(){ SEPARATOR_TOKEN }
	override NAMESPACE_SEPARATOR(){ SEPARATOR_TOKEN }


	override dispatch asLiteral(Type type) {

		switch type {
			case type === null || type.isSame(getType(VOID)) : VOID
			case type.isReal: DOUBLE
			case type.isInteger || isSuperType(type, getType(INTEGER)): LONG
			case type.isBoolean: BOOL
			case type.isString: STRING
			
			default: super._asLiteral(type)
		}
	}
	
	override dispatch String asLiteral(Package it){
		if(isCsNamespace) '''«name»'''
		else super._asLiteral(it)
	}
	
}
