/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.core.concepts.InternallyDefinedTypeAnnotation
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sexec.naming.INamingService
import org.eclipse.emf.ecore.EObject

/**
 * Maps a statechart event to an event which is accessible for the outside and creates a delegate for it 
 * which represents the payload and the sender of the event.
 * It is called by client objects. 
 * 
 * @author Laszlo Kovacs
 */
@Singleton
class OutEvent {
	
	@Inject protected extension CsharpVisibility
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension TypeBuilder
	@Inject protected extension INamingService
	@Inject protected extension Documentation
	@Inject protected extension OriginTracing
	@Inject protected extension InternallyDefinedTypeAnnotation
	
	public static String HANDLER = "Handler"
	
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	
	def void defineEventDefinition(EObject it) {
		eAllContents
			.filter(Event)
			.filter[ direction === Direction.OUT ]
			.toList
			.forEach[ ev |
				(ev.origin as TypedDeclaration).eventDefinition => [ 
					ev.addSibling(it)
				]
			]	
	}
	
	def create it : _variable(e.name ,
			createTypeSpecifier => [
				type = e.delegateType
			]
		) eventDefinition(TypedDeclaration e) {
		_internallyDefinedType
		_event
		documentation(e.documentation)
		traceOrigin(e)
		_public
		const = false
		static = false
		
	}
	
	def ComplexType create createComplexType defineDelegateType(TypedDeclaration e) {

		name = e.asHandler
		
		e.addSibling(it)
	}
	
	def delegateType(TypedDeclaration it) {
		_createCache_defineDelegateType.get(#[it])
	}
	
	def String asHandler(TypedDeclaration it) '''«it.name.asIdentifier»«HANDLER»'''
}