/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpNaming
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.extensions.EventQueueExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

/**
 * This extension defines event queues. 
 * 
 * @author axel terfloth - Initial contribution.
 */
class CsharpEventQueueImplementation{

	public static final String INCOMING_EVENT_QUEUE_NAME= "incomingEventQueue"
	public static final String INTERNAL_EVENT_QUEUE_NAME= "internalEventQueue"
	public static final String GET_NEXT_EVENT_METHOD_NAME= "GetNextEvent"
	public static final String DISPATCH_EVENT_METHOD_NAME= "DispatchEvent"
	public static final String GET_TIME_EVENT_ID_METHOD_NAME= "GetTimeEventId"
	

	@Inject protected extension EventQueue
	@Inject protected extension EventQueueExtension
	
	@Inject protected extension TypeBuilder
	@Inject protected extension SExecExtensions
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension CsharpNaming

	@Inject protected extension StatemachineClass
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension Documentation

	@Inject protected extension GeneratorAssignment
	@Inject protected extension IMethodCode
	@Inject protected extension Literals
	@Inject protected extension CsharpVisibility
		
	
	def void defineEventQueueImplementation(ExecutionFlow flow) {
		
		if (flow.requiresIncomingEventQueue) {
			
			_variable(INCOMING_EVENT_QUEUE_NAME, _any) => [
				_private
				flow.stateMachineClass.features += it;
				generateDeclarationWith[
				'''private Queue<Delegate> «INCOMING_EVENT_QUEUE_NAME» = new Queue<Delegate>();'''
				]			
			]
		}
		
		if (flow.requiresInternalEventQueue) {
			
			_variable(INTERNAL_EVENT_QUEUE_NAME, _any) => [
				_private
				flow.stateMachineClass.features += it;
				generateDeclarationWith[
				'''private Queue<Delegate> «INTERNAL_EVENT_QUEUE_NAME» = new Queue<Delegate>();'''
				]			
			]
		}
		
		
		if (flow.requiresEventQueue) {

			_op(GET_NEXT_EVENT_METHOD_NAME, _boolean) => [
				_protected
				flow.stateMachineClass.features += it;
				
				
				generateDefinitionWith[
					val internalEventQueue = flow.internalEventQueue
					val incomingEventQueue = flow.incomingEventQueue
										
					'''
						«csharpVisibility» «typeSpecifier.type.csharpType» «name»()
						{
							«IF internalEventQueue.exists»
								if(«internalEventQueue.name».Any()) {
									Delegate delegateToRun = «internalEventQueue.name».Dequeue();
									delegateToRun.DynamicInvoke();
									return true;
								}
							«ENDIF»
							«IF incomingEventQueue.exists»
								«IF internalEventQueue.exists»else «ENDIF»if(«incomingEventQueue.name».Any()) {
									Delegate delegateToRun = «incomingEventQueue.name».Dequeue();
									delegateToRun.DynamicInvoke();
									return true;
								}
							«ENDIF»
							
							return false;
							
						}
					''']				
			]									
			
		}
	}
	
	def activateNextEventCode(ExecutionFlow it) {
		if ( nextEventMethod.exists) '''
				«nextEventMethod.name»();
			'''
		else ''''''
	}
	
}
