/**
 * Copyright (c) 2022-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.codepattern.IEnumCode
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.concepts.InternallyDefinedTypeAnnotation
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpNaming
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility
import com.itemis.create.base.generator.csharp.codepattern.ClassCode
import com.itemis.create.base.generator.csharp.codepattern.CodeComment
import com.itemis.create.base.generator.csharp.concepts.EventRaiser
import com.itemis.create.base.generator.csharp.concepts.OutEvent
import com.itemis.create.base.generator.csharp.concepts.OutEventHandler
import com.itemis.create.base.generator.csharp.concepts.OutEventSubscriber
import com.itemis.create.statechart.generator.csharp.codepattern.CsharpTraceCode
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.AssignmentOperator
import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Event
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTraceAdapter
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.codemodel.StatemachineEvents
import com.yakindu.sct.generator.core.concepts.EventMembers
import com.yakindu.sct.generator.core.extensions.EventQueueExtension
import com.yakindu.sct.generator.core.extensions.GeneratorPredicate
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import org.eclipse.emf.ecore.util.EcoreUtil

import static com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder.CSHARP_EVENT_ARGS
import static com.itemis.create.statechart.generator.csharp.codemodel.CsharpNamedInterfaceClasses.*

/**
 * @author laszlo kovacs - Initial contribution.
 */
 @Singleton
class CsharpStatemachineEvents extends StatemachineEvents {

	@Inject protected extension ShadowEventExtensions

	@Inject protected extension IEnumCode
	@Inject protected extension Literals
	@Inject protected extension ClassCode
	@Inject protected extension EventQueueExtension
	@Inject protected extension IMethodCode
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension CsharpNaming
	@Inject protected extension EventMembers
	@Inject protected extension CsharpVisibility
	@Inject protected extension GeneratorPredicate

	@Inject protected extension EventBuffer
	@Inject protected extension CsharpEventQueueImplementation
	@Inject protected extension ITypeSystem
	@Inject protected extension EventRaiser
	@Inject protected extension OutEvent
	@Inject protected extension CsharpNamedInterfaceClasses

	@Inject protected extension ExpressionBuilder
	@Inject protected extension CodeComment
	@Inject protected extension InternallyDefinedTypeAnnotation
	
	@Inject protected extension OutEventSubscriber
	@Inject protected extension OutEventHandler
	@Inject protected extension CsharpTraceEvent
	@Inject protected extension CsharpTraceCode

	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	protected extension ExpressionsFactory = ExpressionsFactory.eINSTANCE

	def Operation create _op(e.name.toFirstUpper + CSHARP_EVENT_ARGS, EcoreUtil.copy(ts)) createEventArg(
		TypeSpecifier ts, TypedDeclaration e) {
		_public
		generateDeclarationWith[
			'''
				«csharpVisibility» class «name» : «CSHARP_EVENT_ARGS»
				{
					«csharpVisibility» «type.targetLanguageName» Payload { get; set; }
				}
			'''
		]

		e.scope.scopeInterface.features += it
	}

	def protected eventArg(TypeSpecifier ts, TypedDeclaration e) {
		_createCache_createEventArg.get(#[ts, e])
	}

	def eventArgsTypeSpecifier(String name) {
		createTypeSpecifier => [ ts |
			ts.type = createType => [ t |
				t.name = name
			]
		]
	}

	def void defineEvents(ExecutionFlow it) {

		scopes.forEach [ s |

			s.eventDefinitions.forEach [ e |
				if (e.isInEvent || e.isLocalEvent) {
					e.defineEventVariables
					if (e.isLocalEvent) {
						s.scopeClass.features += e.defineEventRaiser._protected.withInEventGenerator(e)
					}
					if (e.scope instanceof InterfaceScope) {
						s.scopeClass.features += e.defineEventRaiser._public.withInEventGenerator(e)
					} else if (shadowEvents.contains(e)) {
						s.scopeClass.features += e.defineEventRaiser => [
							_private
							withInEventGenerator(e)
						]
						s.scopeClass.features += e.defineHandlerForEvent
					}
				}

				if (e.isOutEvent) {
					e.scope.scopeClass.features += e.defineOutEventAccessors
				}
			]
		]
	}

	override protected defineEventVariables(EventDefinition e) {
		val evRaisedFlag = e.defineEventRaisedFlag => [
			if (e.scope.isNamedScope) {
				_internal
				generateDefinitionWith[getterSetter(true, true, "")]
			}
			generateDeclarationWith[variableDeclarationCode]
		]
		if(e.scope.isInNamedInterface){
			evRaisedFlag.origin = null
			e.scope.scopeInterface.features += evRaisedFlag.defineEventSignature=>[traceOrigin(e)]	
		}

		if (e.hasValue) {
			val evValue = e.defineEventValueMember => [
				if (e.scope.isNamedScope) {
					annotations.clear
					_internal
					generateDefinitionWith[getterSetter(true, true, "")]
				}
				generateDeclarationWith[variableDeclarationCode]
			]
			if(e.scope.isInNamedInterface)
				e.scope.scopeInterface.features += evValue.defineEventSignature
		}
		evRaisedFlag
	}

	def protected withInEventGenerator(Operation it, EventDefinition e) {
		generateDefinitionWith[
			'''
				«codeComment»
				«csharpVisibility» void «it.name»(«e.valueParams») {
					«IF e.isQueued»
						«IF e.isLocalEvent»
							«e.flow.internalEventQueue.queueEventCode(it, e, e.asParameter)»;
						«ELSE»
							«e.flow.incomingEventQueue.queueEventCode(it, e, e.asParameter)»;
						«ENDIF»
					«ELSE»
						«e.activateEventCode»
					«ENDIF»
					«IF e.hasValue»«e.traceCode(e.value)»«ELSE»«e.traceCode("null")»«ENDIF»
					«IF e.flow.isEventDriven && !e.isLocalEvent»
						«IF e.scope.namedInterfaceClass?.features?.contains(it)»«PARENT».«ENDIF»«e.flow.runCycle.csharpName»();
					«ENDIF»
				}
			'''
		]
	}

	def protected withOutEventGenerator(Operation it, TypedDeclaration e) {
		generateDefinitionWith[
			'''
				«csharpVisibility» void «it.name»(«FOR p : parameters SEPARATOR ", "»«p.typeSpecifier.asLiteral»«IF !p.type.superTypes.nullOrEmpty»<«FOR st : p.type.superTypes.map[type] SEPARATOR ", "»«st.name»«IF st.nullable»?«ENDIF»«ENDFOR»>«ENDIF» «p.name»«ENDFOR») {
					«e.eventDefinition.name»?.Invoke(this, «IF e === e.stateMachineClass.traceEventForStm»value«ELSE»new «IF e.hasMetaValue»«e.metaFeatures.filter(Property).head.typeSpecifier.eventArg(e)»«ELSE»«CSHARP_EVENT_ARGS»«ENDIF»()«IF e.hasMetaValue»{
						Payload = «e.asParameter»
					}«ENDIF»«ENDIF»);
					«IF e instanceof Event && (e as Event).getLocalOutEvent !== null»«IF e.scope.needsStatemachineReference && e.isInNamedInterface»«PARENT».«ENDIF»«e.flow.getLocalEvents.filter(ev | ev.originEvent === e).head.asRaiser»(«FOR p:parameters SEPARATOR ", "»«p.name»«ENDFOR»);«ENDIF»
					«IF useOutEventGetters && e.eventRaisedFlagType !== null»«e.eventRaisedFlagType.name» = true;
					«IF e.eventValueMemberType !== null»«e.eventValueMemberType.name» = value;«ENDIF»«ENDIF»
				}
			'''
		]
	}

	def defineOutEventAccessors(TypedDeclaration e) {
		e.defineDelegateOperation => [name = e.asHandler; _public]
		e.defineDelegateType => [e.scope !== null ? e.scope.scopeInterface.features += it]
		
		e.eventDefinition => [
			
			if(useOutEventGetters) it.eAdapters.remove(it.eAdapters.filter(OriginTraceAdapter).head) 
			
			generateDeclarationWith[variableDeclarationCode]
		
			val container = e.scope !== null ? e.scope : e.eContainer
			container.scopeInterface.features += it
	
			if(e.scope.isNamedScope)
				e.scope.scopeClass.features += it.copy => [generateDeclarationWith[variableDeclarationCode]]
		
		]
		if (e.hasValue)
			e.typeSpecifier.createEventArg(e)
		else if (!e.metaFeatures.nullOrEmpty)
			e.metaFeatures.filter(Property).head.typeSpecifier.createEventArg(e)

		if (useOutEventGetters && e.flow !== null) {
			e.outEventGetters
		}

		e.defineEventRaiser.withOutEventGenerator(e) => [_public]
	}

	def outEventGetters(TypedDeclaration e) {
		val evRaisedFlag = e.defineEventRaisedFlag => [
			_public
			_internallyDefinedType
			generateDefinitionWith[getterSetter(true, true, "")]
			generateDeclarationWith[variableDeclarationCode]
		]
		if(e.scope.isInNamedInterface)
			e.scope.scopeInterface.features += evRaisedFlag.defineEventSignature=>[traceOrigin(e)]
		if (e.hasValue) {
			val evValue = e.defineEventValueMember => [
				_public
				generateDefinitionWith[getterSetter(true, true, "")]
				generateDeclarationWith[variableDeclarationCode]
			]
			if(e.scope.isInNamedInterface)
				e.scope.scopeInterface.features += evValue.defineEventSignature
		}
	}
	
	def create r : _variable(ev.name.toFirstUpper, ev.type) defineEventSignature(TypedDeclaration ev){
		r._public
		r.generateDefinitionWith[
			r.getterSetterSignature(true, true)
		]		
	}
	
	def eventSignature(TypedDeclaration it) {
		_createCache_defineEventSignature.get(#[it])	
	}

	def protected defineSubscription(EventDefinition e) {
		val method = _op(e.asSubscribe, getType('void')) => [
			val param = createParameter => [
				name = 'handlerToRegister'
				typeSpecifier = createTypeSpecifier => [ ts |
					ts.type = e.delegateType
				]
			]
			parameters += param
			documentation('''Function to subscribe for out event«e.name»''')
			_public
			static = false
			implementation = _block(e.eventDefinition._ref._assignment(param._ref) => [
				operator = AssignmentOperator::ADD_ASSIGN
			])
			generateDefinitionWith[methodDefinitionCode]
		]
		e.scope.scopeClass.features += method
		return method
	}

	def protected delegateParams(Operation it, TypedDeclaration e) {
		val container = e.scope !== null ? e.scope : e.eContainer
		_param(container.scopeInterface.name + " sender", createVoidType) => [_eventArgs]
		if (e.hasValue) {
			_param(name.toFirstUpper + CSHARP_EVENT_ARGS + " e", EcoreUtil.copy(e.typeSpecifier)) => [_eventArgs]
		} else if (!e.metaFeatures.nullOrEmpty) {
			_param(name.toFirstUpper + CSHARP_EVENT_ARGS + " e",
				EcoreUtil.copy(e.metaFeatures.filter(Property).head.typeSpecifier)) => [_eventArgs]
		} else if (e.type !== null && !e.type.superTypes.nullOrEmpty){
			_param(e.type + '''<«FOR st : e.type.superTypes.map[type] SEPARATOR ", "»«st.name»«IF st.nullable»?«ENDIF»«ENDFOR»>''' + " e", EcoreUtil.copy(e.typeSpecifier)) => [_eventArgs]
		} else {
			_param(CSHARP_EVENT_ARGS + " e", createVoidType) => [_eventArgs]
		}
	}

	def protected createVoidType() {
		createTypeSpecifier => [
			type = getType('void')
		]
	}

	def protected Operation create _op(e.name.asIdentifier) defineDelegateOperation(TypedDeclaration e) {

		typeSpecifier = createTypeSpecifier => [
			type = getType('void')
		]
		delegateParams(e)
		val container = e.scope !== null ? e.scope : e.eContainer
		documentation('''Delegate for event «e.name» «IF e.scope !== null»of «e.scope.scopeDescription»«ENDIF».''')
		_delegate
		static = false
		generateDeclarationWith[methodDeclarationCode]
		
		container.scopeInterface.features += it
	}

	def protected ComplexType create createComplexType defineDelegateType(EventDefinition e) {

		name = e.asHandler

		e.scope.scopeInterface.features += it
	}

	def delegateType(EventDefinition it) {
		_createCache_defineDelegateType.get(#[it])
	}

	override queueEventCode(Property queue, Declaration context, EventDefinition e, String valueCode) '''
	«IF e.scope.namedInterfaceClass?.features?.contains(context)»«PARENT».«ENDIF»«queue.name».Enqueue(() => {
		«e.activateEventCode»
	})'''

	override dispatch asParameter(EventDefinition it) {
		'''value'''
	}

	override asRaiser(EventDefinition it) {
		'Raise' + name.asIdentifier.toFirstUpper
	}
	
	override valueParams(EventDefinition it) {
		if(hasValue) typeSpecifier.asLiteral + " " + asParameter
		else if(hasMetaValue) getMetaValue.asLiteral + " " + asParameter
		else ''
	}

}
