/**
 * Copyright (c) 2022-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.concepts.EventRaiser
import com.itemis.create.base.generator.csharp.concepts.OutEvent
import com.itemis.create.base.generator.csharp.concepts.OutEventHandler
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.ConditionalExpression
import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Direction
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Event
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeAlias
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.concepts.EventMembers
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import java.util.List
import org.eclipse.emf.ecore.EObject

import static com.itemis.create.statechart.generator.csharp.codemodel.CsharpNamedInterfaceClasses.PARENT

/**
 * @author laszlo kovacs - Initial contribution.
 */
class CsharpStatemachineMembers {

	@Inject protected extension StatemachineClass
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension ExpressionExtensions
	@Inject protected extension SExecExtensions
	@Inject protected extension CsharpNamedInterfaceClasses
	@Inject protected extension TypeBuilder
	@Inject protected extension Documentation
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IVariableCode
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension OriginTracing
	@Inject protected extension ITypeValueProvider
	@Inject protected extension Statechart2TypeTransformation
	@Inject protected extension EventRaiser
	@Inject protected extension OutEvent
	@Inject protected extension OutEventHandler
	@Inject protected extension ShadowEventExtensions
	@Inject protected extension EventMembers
	@Inject protected extension StateEnum
	@Inject protected extension CsharpStatemachineEvents

	protected extension ExpressionsFactory expFactory = ExpressionsFactory.eINSTANCE

	def defineMembers(ExecutionFlow flow) {

		flow.scopes.forEach [ s |
			s.declarations.filter(Property).forEach [ d |
				s.scopeClass.features += d.defineDeclaration
				s.scopeClass.features += d.defineDefinition
				if (d.type.statechartType)
					s.scopeClass.features += d.defineChildStm
				if (s.isNamedScope)
					s.scopeInterface.features += d.defineSignature
			]
		]
	}

	def dispatch defineSignature(Property prop) {
		val member = _variable(prop.keywordEscapedName, prop.getTypeOrAlias) => [
			const = prop.isConst
			_public
			generateDefinitionWith[getterSetterSignature(true, if(!prop.const) true else false)]
		]
		return member
	}

	def dispatch defineSignature(Declaration it) {}

	def dispatch defineDeclaration(Property prop) {
		_variable(prop.keywordEscapedName, prop.getTypeOrAlias) => [
			documentation(prop.documentation)
			if(prop.initialValue !== null){
				if(prop.initialValue.featureOrReference !== null && 
					prop.initialValue.featureOrReference instanceof TypedDeclaration &&
					(prop.initialValue.featureOrReference as TypedDeclaration).type.statechartType
				)
					_required
				else
					initialValue = prop.initialValue.defineInitialValue
			}
			_private
			_user_declared
			const = prop.isConst
			static = prop.isStatic
			generateDeclarationWith[variableDeclarationCode]
		]
	}

	def create childStm : _complexType(prop.keywordEscapedName) defineChildStm(Property prop) {
		childStm.traceOrigin(prop)
		val shadow = prop.flow?.shadowEvents?.toList
		childStm._annotate(Statechart2TypeTransformation.CHILD_STATECHART_ANNOTATION)
		(prop.type as ComplexType).features.forEach[ f |
			if(f instanceof ComplexType){
				val iFace = _complexType(f.name)
				childStm.features += iFace
				f.addFeaturesDerivedFrom(iFace , shadow)
			} 
		]
		(prop.type as ComplexType).addFeaturesDerivedFrom(childStm, shadow)
	}
	
	def addFeaturesDerivedFrom(ComplexType it, ComplexType target, List<Event> shadow){
		it.annotations.forEach[ annot |
			target.annotations += annot.copy
		]
		features.filter(EventDefinition).forEach [ e |
			if (e.direction === Direction.IN) {
				target.features += e.copy.defineEventRaiser => [
					traceOrigin(e)
				]
			}
			if (e.direction === Direction.OUT) {
				if (!shadow.nullOrEmpty && shadow.map[originTraces.filter(VariableDefinition).head].contains(target.originOfTarget) &&
					shadow.map[originTraces.filter(EventDefinition).head].contains(e.origin)
				){
					val shadowEv = shadow
					// Check if we are in the right childStm
					.filter[originTraces.filter(VariableDefinition).head === target.originOfTarget]
					// Check for the corresponding event
					.filter[originTraces.filter(EventDefinition).head === e.origin].head
					val ecCopy = shadowEv.copy
					target.features += ecCopy
					target.features += (shadowEv.origin as TypedDeclaration).eventDefinition.copy => [
						traceOrigin(ecCopy)
					]
					val handlerForEvent = shadowEv.handlerForEvent
					target.features += handlerForEvent.copy => [
						traceOrigin(ecCopy)
					]
				}
				else{
					target.features += e.defineEventRaisedFlag => [origin = null]
					target.features += e.defineEventRaisedFlag.defineEventSignature=>[traceOrigin(e)]
					if (e.hasValue){
						target.features += e.defineEventValueMember
						target.features += e.defineEventValueMember.defineEventSignature
					}						
				}
			}
		]
		
		features.filter(Property).forEach [ p |
			if (p.type.statechartType)
				target.features += p.defineChildStm
			target.features += p.defineDefinition
		]
		target
	}
	
	def private originOfTarget(ComplexType it){
		if(isNamedIface)
			eContainer.origin
		else
			origin
	}

	def childStm(Property it) {
		_createCache_defineChildStm.get(#[it])
	}

	def dispatch defineDefinition(Property prop) {
		val member = _variable(prop.keywordEscapedName.toFirstUpper, prop.getTypeOrAlias) => [
			traceOrigin(prop)
			const = prop.isConst
			_public
			generateDefinitionWith[
				if (prop.childStm !== null) {
					val outEvents = prop.childStm.eAllContents.filter(EventDefinition).toList
					if(!outEvents.nullOrEmpty){
						val subscriptions = '''«FOR e : prop.childStm.eAllContents.filter(EventDefinition).toList»«prop.childStm.name.toFirstLower».«IF e.eContainer.isNamedIface»«(e.eContainer as NamedElement).name».«ENDIF»«(e.eContainer as ComplexType).features.filter[origin === e && !isHandler].head.name» += «e.eventHandler»;«ENDFOR»'''
						getterSetter(true, if(!prop.const) true else false, subscriptions)
					} else
						getterSetter(true, if(!prop.const) true else false, "")
				} else
					getterSetter(true, if(!prop.const) true else false, "")
			]
		]
		return member
	}
	
	def private eventHandler(EventDefinition e){
		val handler = e.eContainer.eAllContents.filter(Operation).filter[origin === e && isHandler].head.name 
		if(e.eContainer.isNamedIface && e.stateMachineClass.eAllContents.filter(NamedElement).exists[name == PARENT])
			return PARENT + "." + handler
		else
			return handler
	}

	def getInternalChildEvent(EventDefinition childEvent) {
		childEvent.stateMachineClass.eAllContents.filter(Operation).filter [
			origin === (childEvent.origin as EObject).origin
		].head.origin as EventDefinition
	}

	def dispatch defineDeclaration(Declaration it) {}

	def dispatch defineDefinition(Declaration it) {}

	def dispatch defineInitialValue(ConditionalExpression it) {
		it.copy => [ ce |
			ce.condition = it.condition.getInitialValue
		]
	}

	def dispatch defineInitialValue(Expression it) {
		it.copy
	}

	def dispatch Expression getInitialValue(EObject it) {}

	def dispatch Expression getInitialValue(ArgumentExpression it) {
		it.featureOrReference.getInitialValue
	}

	def dispatch Expression getInitialValue(VariableDefinition it) {
		if (initialValue !== null)
			initialValue
	}

	def protected getTypeOrAlias(Property prop) {
		if (prop.type.statechartType)
			return prop.type.stateMachineClass
		if (prop.type instanceof TypeAlias) {
			val origin = prop.type as TypeAlias
			origin.typeSpecifier.type
		} else if(prop.type instanceof EnumerationType && prop.type.origin instanceof Statechart) {
			(prop.type.origin as Statechart).stateEnum
		} else
			prop.typeSpecifier.type
	}

}
