/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpNaming
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility
import com.itemis.create.statechart.generator.csharp.codepattern.CsharpTraceCode
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Event
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.concepts.ShadowMemberScope
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.List
import com.itemis.create.base.generator.core.concepts.InternallyDefinedTypeAnnotation

/**
 * TODO: all methods in this class must be checked for moving to concept definitions.
 * 
 * @author laszlo kovacs - Initial contribution.
 * @author axel terfloth - updates
 * 
 * @deprecated
 */
class CsharpStatemachineNaming {
	@Inject protected extension INamingService
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension StatemachineClass
	@Inject protected extension SExecExtensions
	@Inject protected extension Literals
	@Inject protected extension OriginTracing
	@Inject protected extension CsharpNaming
	@Inject protected extension CsharpTypeBuilder

	@Inject protected extension ShadowMemberScope

	@Inject protected extension CsharpVisibility
	@Inject protected extension InternallyDefinedTypeAnnotation
	
	@Inject protected extension CsharpTraceCode

	

	def String cs(String it) '''«it».cs'''

	// === copied from C Naming

	public static final String PARENT_MEMBER = "parent";

	def List<String> statechartNamespace(Statechart sct) {
		if (sct === null) {
			return emptyList
		}
		var ns = sct.namespace
		if (ns === null || ns == "") {
			return emptyList
		}
		return newArrayList(ns.replace(".", "::").replace("/", "::").split("::").filter[!nullOrEmpty])
	}

	// ===

	def dispatch String csharpType(ExecutionFlow it) {
		name.asIdentifier.toFirstUpper
	}

	def dispatch String csharpType(Type it) {
		if(! it.targetLanguageName.isNullOrEmpty) return targetLanguageName
		if(! it.name.isNullOrEmpty) return it.name

	}

	def eventType(Event it) { if(hasValue) return '''_«typeSpecifier.targetLanguageName»''' }
	
	def CharSequence getterSetter(Property it, boolean get, boolean set, String subscriptions) '''
		public «typeSpecifier.asLiteral»«IF ((!const && userDeclared) || type.nullable)»?«ENDIF» «keywordEscapedName.replaceAll("^[^a-zA-Z0-9\\s]","").toFirstUpper» { «IF get»«getter»«ENDIF» «IF set»«setter(subscriptions)»«ENDIF»}
	'''
	
	def getterSetterSignature(TypedDeclaration it, boolean get, boolean set) '''
		public «typeSpecifier.targetLanguageName»«IF (userDeclared || type.nullable)»?«ENDIF» «keywordEscapedName.replaceAll("^[^a-zA-Z0-9\\s]","").toFirstUpper» { «IF get»get;«ENDIF» «IF set»set;«ENDIF» }
	'''

	def protected getter(Property it) '''
	get { return «keywordEscapedName.toFirstLower»; }'''
	
	def protected setter(Property it, String subscriptions) '''
	set { «keywordEscapedName.toFirstLower» = value; «subscriptions» «IF !isInternallyDefinedType»«it.traceCode('''this.«identifier»''')»«ENDIF»}'''

	def keywordEscapedName(TypedDeclaration it){
		(it.origin instanceof VariableDefinition || it instanceof VariableDefinition) && (name.isCsharpKeyword || name.isStatechartKeyword) ? name + separator + 'ID' : name
	}
	
	def String asSubscribe(Event it) '''SubscribeTo«it.name.toFirstUpper»'''

	
	

	def dispatch identifier(Property it) {
		if(it.flow !== null && it.eContainer == flow.stateMachineClass) name.asIdentifier.toFirstUpper else name.asIdentifier
	}

	def dispatch identifier(Event it) { name.asIdentifier }

	def dispatch identifier(Method it) { shortName.toFirstUpper }

	def dispatch identifier(Operation it) { name.toFirstUpper }

	def dispatch identifier(Enumerator it) { name }
	
	def dispatch identifier(EnumerationType it) {namespacePath + name }

	def dispatch identifier(Declaration it) { shortName.toFirstUpper }

}
