/**
 * Copyright (c) 2022-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Property
import com.yakindu.sct.generator.core.codemodel.StatemachineProperties

class CsharpStatemachineProperties extends StatemachineProperties {
	
	@Inject protected extension CsharpStatemachineNaming
	
	override definePropertie(Property p) {
		if (p.type instanceof ComplexType)
			_part(p.name, p.type) => [
				generalProperties(p)
			]
		else
			_variable(p.name, p.type) => [
				generalProperties(p)
				generateDefinitionWith[getterSetter(true, true,"")]
			]
	}
}
