package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.itemis.create.base.generator.csharp.codemodel.CsharpCompilationUnit
import com.itemis.create.base.generator.csharp.codemodel.CsharpStatemachineLibrary
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Property
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.core.tracing.TraceEvent

@Singleton
class CsharpTraceEvent extends TraceEvent {
	
	public static String TRACE_EVENT = "TraceEvent"

	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension CsharpStatemachineLibrary
	@Inject protected extension CsharpClass
	@Inject protected extension CsharpCompilationUnit
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension IVariableCode
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension StateEnum

	def create c: _variable("trace") traceEventHandler() {
	}

	def traceEventUnit() {
		_compilationUnit => [ cu |
			cu.name = TRACE_EVENT
			cu.member += genericTraceEvent
		]
	}

	def traceEventTypeUnit() {
		_compilationUnit => [ cu |
			cu.name = traceEventType.name
			cu.member += traceEventType
		]
	}
	
	def create tev : _variable(genericTraceEvent.name) traceEventForStm(ComplexType stm){
		tev._type = createComplexType() => [ c |
			c.name = genericTraceEvent.name
			c.superTypes += createTypeSpecifier => [
				type = stm
			]
			c.superTypes += createTypeSpecifier => [
				type = stm.stateEnum.copy => [_nullable]
			]
			c.superTypes += createTypeSpecifier => [
				type = stm.traceEventFeature => [_nullable]
			]
		]
	}

	def create c: createComplexType() genericTraceEvent() {
		c._csharpClass
		
		c.name = TRACE_EVENT

		val machineType = createComplexType => [
			name = "M"
			_generic_type
			superTypes += createTypeSpecifier => [
				type = statemachineInterface
			]
		]

		val stateType = createComplexType => [
			name = "S"
			_nullable
			_generic_type
		]

		val featureType = createComplexType => [
			name = "F"
			_nullable
			_generic_type
		]
		
		val objectType = createType => [
			_nullable
			name = "object"
		]

		c.superTypes += createTypeSpecifier => [
			type = machineType
		]
		c.superTypes += createTypeSpecifier => [
			type = stateType
		]
		c.superTypes += createTypeSpecifier => [
			type = featureType
		]

		val eventType = _variable("type", traceEventType) => [
			_private
			generateDeclarationWith[variableDeclarationCode]
			generateDefinitionWith[getterSetter(true, false, "")]
		]
		
		c.features += eventType

		val machine = _variable("machine", machineType) => [
			_private
			generateDeclarationWith[variableDeclarationCode]
			generateDefinitionWith[getterSetter(true, false, "")]
		]
		
		c.features += machine

		c.features += _variable("state", stateType) => [
			_private
			generateDeclarationWith[variableDeclarationCode]
			generateDefinitionWith[getterSetter(true, false, "")]
		]
		
		c.features += _variable("feature", featureType) => [
			_private
			generateDeclarationWith[variableDeclarationCode]
			generateDefinitionWith[getterSetter(true, false, "")]
		]
		
		c.features += _variable("value", objectType) => [
			_private
			generateDeclarationWith[variableDeclarationCode]
			generateDefinitionWith[getterSetter(true, false, "")]
		]
		
		val ctr = _op(c.name) => [
			_public
			generateDefinitionWith[ '''
			«visibility.visibilityName» «name»(«eventType.type» «eventType.name», «machine.type» «machine.name»)
				: this(«eventType.name», «machine.name», default, default, null)
			{
			}
			«visibility.visibilityName» «name»(«FOR member : c.features.filter(Property) SEPARATOR ", "»«member.type» «member.name»«ENDFOR»)
			{
				«FOR member : c.features.filter(Property)»
				this.«member.name» = «member.name»;
				«ENDFOR»
			}
			
			''' ]
		]
		
		c.features += ctr

	}
}
