/**
 * Copyright (c) 2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.features

import com.google.inject.Inject
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgen.GeneratorModel
import com.yakindu.sct.model.sgraph.Statechart
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil

import static com.itemis.create.base.generator.csharp.features.ICsharpFeatureConstants.*

import static extension org.eclipse.xtext.EcoreUtil2.*

class CsharpStatechartGenmodelEntries extends CsharpGenmodelEntries {
	
	@Inject extension StringHelper
	
	def getBaseNamespace(GeneratorEntry it) {
		(basePackageParameter?.stringValue ?: BASE_NAMESPACE_DEFAULT).dot(statechart?.namespace)
	}
	
	def getBaseNamespace(GeneratorEntry entry, Statechart context) {
		val contextEntry = (entry.model.entryFor(context) ?: entry)
		(contextEntry.basePackageParameter?.stringValue ?: BASE_NAMESPACE_DEFAULT).dot(context.namespace)
	}
	
	private def getModel(GeneratorEntry it) {
		getContainerOfType(GeneratorModel)
	}
	
	private def entryFor(GeneratorModel it, EObject element) {
		entries.findFirst[EcoreUtil.equals(elementRef, element)]
	}
	
	def getStatechart(GeneratorEntry it) {
		if (elementRef instanceof Statechart) 
			elementRef as Statechart
		else
			null as Statechart
	}
}
