/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext

import com.google.inject.Binder
import com.google.inject.multibindings.Multibinder
import com.google.inject.name.Names
import com.yakindu.base.expressions.linking.ArgumentLinkingService
import com.yakindu.base.expressions.linking.LinkingDiagnosticMessageProvider
import com.yakindu.base.expressions.parser.SyntaxErrorMessageProvider
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.base.types.libraries.ITypeLibraryProvider
import com.yakindu.base.types.scoping.IPackageImport2URIMapper
import com.yakindu.base.types.scoping.PackageImport2URIMultiMapper
import com.yakindu.base.types.scoping.TypeLibraryImport2URIMapper
import com.yakindu.base.types.typesystem.GenericTypeSystem
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.sgraph.resource.SCTLinker
import com.yakindu.sct.model.stext.inferrer.STextTypeInferrer
import com.yakindu.sct.model.stext.naming.StextNameProvider
import com.yakindu.sct.model.stext.resource.SCTResourceDescriptionStrategy
import com.yakindu.sct.model.stext.resource.StextResource
import com.yakindu.sct.model.stext.scoping.STextGlobalScopeProvider
import com.yakindu.sct.model.stext.scoping.StextImportAwareScopeProvider
import com.yakindu.sct.model.stext.serialization.STextTransientValueService
import com.yakindu.sct.model.stext.serializer.SCTSerializer
import com.yakindu.sct.model.stext.terminals.STextValueConverterService
import com.yakindu.sct.model.stext.validation.STextNamesAreUniqueValidationHelper
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.Constants
import org.eclipse.xtext.conversion.IValueConverterService
import org.eclipse.xtext.linking.ILinker
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider
import org.eclipse.xtext.linking.ILinkingService
import org.eclipse.xtext.naming.IQualifiedNameProvider
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy
import org.eclipse.xtext.scoping.IGlobalScopeProvider
import org.eclipse.xtext.scoping.IScopeProvider
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider
import org.eclipse.xtext.serializer.ISerializer
import org.eclipse.xtext.serializer.sequencer.ITransientValueService
import org.eclipse.xtext.service.AbstractGenericModule
import org.eclipse.xtext.validation.CompositeEValidator
import org.eclipse.xtext.validation.INamesAreUniqueValidationHelper
import com.yakindu.base.types.libraries.TypeLibraryRegistry

@SuppressWarnings("restriction")
class STextRuntimeOverrideModule extends AbstractGenericModule {

	def Class<? extends ITransientValueService> bindITransientValueServiceSerializer() {
		STextTransientValueService
	}

	def Class<? extends IDefaultResourceDescriptionStrategy> bindIDefaultResourceDescriptionStrategy() {
		SCTResourceDescriptionStrategy
	}

	def configureEObjectValidator(Binder binder) {
		binder.bind(boolean).annotatedWith(Names.named(CompositeEValidator.USE_EOBJECT_VALIDATOR)).toInstance(false)
	}

	def configureITypeSystem(Binder binder) {
		binder.bind(ITypeSystem).toInstance(GenericTypeSystem.getInstance())
	}

	def Class<? extends ITypeLibraryProvider> bindITypeLibraryProvider() {
		TypeLibraryRegistry
	}
	
	def configureImport2URIMappers(Binder binder) {
		var setBinder = Multibinder.newSetBinder(binder,
						IPackageImport2URIMapper, Names.named(PackageImport2URIMultiMapper.MULTI_MAPPINGS));
		setBinder.permitDuplicates
		setBinder.addBinding().to(TypeLibraryImport2URIMapper);
	}
	
	def Class<? extends SyntaxErrorMessageProvider> ISyntaxErrorMessageProvider() {
		SyntaxErrorMessageProvider
	}

	def Class<? extends ILinkingDiagnosticMessageProvider> bindILinkingDiagnosticMessageProvider() {
		LinkingDiagnosticMessageProvider
	}

	// https://github.com/Yakindu/statecharts/issues/1199
	def Class<? extends IReferableElementsUnloader> bindIReferableElementsUnloader() {
		IReferableElementsUnloader.NullUnloader
	}

	def Class<? extends INamesAreUniqueValidationHelper> bindNamesAreUniqueValidationHelper() {
		STextNamesAreUniqueValidationHelper
	}

	def Class<? extends IGlobalScopeProvider> bindIGlobalScopeProvider() {
		STextGlobalScopeProvider
	}

	def Class<? extends ILinker> bindILinker() {
		SCTLinker
	}

	def Class<? extends Resource> bindResource() {
		StextResource
	}

	def Class<? extends IQualifiedNameProvider> bindIQualifiedNameProvider() {
		StextNameProvider
	}

	def Class<? extends IValueConverterService> bindIValueConverterService() {
		STextValueConverterService
	}

	def configureFileExtensions(Binder binder) {
		binder.bind(String).annotatedWith(Names.named(Constants.FILE_EXTENSIONS)).toInstance("stext,sct")
	}

	def configureIScopeProviderDelegate(Binder binder) {
		binder.bind(IScopeProvider).annotatedWith(Names.named(AbstractDeclarativeScopeProvider.NAMED_DELEGATE)).to(
			StextImportAwareScopeProvider)
	}

	def Class<? extends ITypeSystemInferrer> bindITypeSystemInferrer() {
		STextTypeInferrer
	}

	def Class<? extends ILinkingService> bindILinkingService() {
		ArgumentLinkingService
	}

	def Class<? extends ISerializer> bindISerializer() {
		SCTSerializer
	}
}
