/*
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.formatting2

import com.yakindu.base.expressions.formatting2.ExpressionsFormatter
import com.yakindu.base.types.Declaration
import com.yakindu.sct.model.stext.stext.StatechartScope
import org.eclipse.xtext.formatting2.IFormattableDocument

class STextFormatter extends ExpressionsFormatter {

	def dispatch void format(StatechartScope it, extension IFormattableDocument document) {
		prepend[newLines]
		interior[indent]
		it.members.forEach[prepend[newLines] format]
		regionFor.keyword(":").append[noSpace].prepend[noSpace]
	}

	def dispatch void format(Declaration it, extension IFormattableDocument document) {
		prepend[newLines]
		interior[indent]
	}

}
