/*
* Copyright (c) 2025 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
grammar InternalSText;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package com.yakindu.sct.model.stext.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package com.yakindu.sct.model.stext.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import com.yakindu.sct.model.stext.services.STextGrammarAccess;

}

@parser::members {

 	private STextGrammarAccess grammarAccess;

    public InternalSTextParser(TokenStream input, STextGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "Root";
   	}

   	@Override
   	protected STextGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleRoot
entryRuleRoot returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRootRule()); }
	iv_ruleRoot=ruleRoot
	{ $current=$iv_ruleRoot.current; }
	EOF;

// Rule Root
ruleRoot returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getRootAccess().getRootsDefRootParserRuleCall_0());
			}
			lv_roots_0_0=ruleDefRoot
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getRootRule());
				}
				add(
					$current,
					"roots",
					lv_roots_0_0,
					"com.yakindu.sct.model.stext.SText.DefRoot");
				afterParserOrEnumRuleCall();
			}
		)
	)*
;

// Entry rule entryRuleDefRoot
entryRuleDefRoot returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDefRootRule()); }
	iv_ruleDefRoot=ruleDefRoot
	{ $current=$iv_ruleDefRoot.current; }
	EOF;

// Rule DefRoot
ruleDefRoot returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getDefRootAccess().getStatechartRootParserRuleCall_0());
		}
		this_StatechartRoot_0=ruleStatechartRoot
		{
			$current = $this_StatechartRoot_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDefRootAccess().getStateRootParserRuleCall_1());
		}
		this_StateRoot_1=ruleStateRoot
		{
			$current = $this_StateRoot_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDefRootAccess().getTransitionRootParserRuleCall_2());
		}
		this_TransitionRoot_2=ruleTransitionRoot
		{
			$current = $this_TransitionRoot_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleStatechartRoot
entryRuleStatechartRoot returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStatechartRootRule()); }
	iv_ruleStatechartRoot=ruleStatechartRoot
	{ $current=$iv_ruleStatechartRoot.current; }
	EOF;

// Rule StatechartRoot
ruleStatechartRoot returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='@@statechart@@'
		{
			newLeafNode(otherlv_0, grammarAccess.getStatechartRootAccess().getStatechartKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getStatechartRootAccess().getDefStatechartSpecificationParserRuleCall_1_0());
				}
				lv_def_1_0=ruleStatechartSpecification
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStatechartRootRule());
					}
					set(
						$current,
						"def",
						lv_def_1_0,
						"com.yakindu.sct.model.stext.SText.StatechartSpecification");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleStateRoot
entryRuleStateRoot returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStateRootRule()); }
	iv_ruleStateRoot=ruleStateRoot
	{ $current=$iv_ruleStateRoot.current; }
	EOF;

// Rule StateRoot
ruleStateRoot returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='@@state@@'
		{
			newLeafNode(otherlv_0, grammarAccess.getStateRootAccess().getStateKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getStateRootAccess().getDefStateSpecificationParserRuleCall_1_0());
				}
				lv_def_1_0=ruleStateSpecification
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStateRootRule());
					}
					set(
						$current,
						"def",
						lv_def_1_0,
						"com.yakindu.sct.model.stext.SText.StateSpecification");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleTransitionRoot
entryRuleTransitionRoot returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTransitionRootRule()); }
	iv_ruleTransitionRoot=ruleTransitionRoot
	{ $current=$iv_ruleTransitionRoot.current; }
	EOF;

// Rule TransitionRoot
ruleTransitionRoot returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='@@transition@@'
		{
			newLeafNode(otherlv_0, grammarAccess.getTransitionRootAccess().getTransitionKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTransitionRootAccess().getDefTransitionSpecificationParserRuleCall_1_0());
				}
				lv_def_1_0=ruleTransitionSpecification
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTransitionRootRule());
					}
					set(
						$current,
						"def",
						lv_def_1_0,
						"com.yakindu.sct.model.stext.SText.TransitionSpecification");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleStatechartSpecification
entryRuleStatechartSpecification returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStatechartSpecificationRule()); }
	iv_ruleStatechartSpecification=ruleStatechartSpecification
	{ $current=$iv_ruleStatechartSpecification.current; }
	EOF;

// Rule StatechartSpecification
ruleStatechartSpecification returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getStatechartSpecificationAccess().getStatechartSpecificationAction_0(),
					$current);
			}
		)
		(
			otherlv_1='namespace'
			{
				newLeafNode(otherlv_1, grammarAccess.getStatechartSpecificationAccess().getNamespaceKeyword_1_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getStatechartSpecificationAccess().getNamespaceFQNParserRuleCall_1_1_0());
					}
					lv_namespace_2_0=ruleFQN
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getStatechartSpecificationRule());
						}
						set(
							$current,
							"namespace",
							lv_namespace_2_0,
							"com.yakindu.sct.model.stext.SText.FQN");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getStatechartSpecificationAccess().getAnnotationsAnnotationParserRuleCall_2_0());
				}
				lv_annotations_3_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStatechartSpecificationRule());
					}
					add(
						$current,
						"annotations",
						lv_annotations_3_0,
						"com.yakindu.sct.model.stext.SText.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getStatechartSpecificationAccess().getScopesStatechartScopeParserRuleCall_3_0());
				}
				lv_scopes_4_0=ruleStatechartScope
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStatechartSpecificationRule());
					}
					add(
						$current,
						"scopes",
						lv_scopes_4_0,
						"com.yakindu.sct.model.stext.SText.StatechartScope");
					afterParserOrEnumRuleCall();
				}
			)
		)*
	)
;

// Entry rule entryRuleStateSpecification
entryRuleStateSpecification returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStateSpecificationRule()); }
	iv_ruleStateSpecification=ruleStateSpecification
	{ $current=$iv_ruleStateSpecification.current; }
	EOF;

// Rule StateSpecification
ruleStateSpecification returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getStateSpecificationAccess().getStateSpecificationAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getStateSpecificationAccess().getAnnotationsAnnotationParserRuleCall_1_0());
				}
				lv_annotations_1_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStateSpecificationRule());
					}
					add(
						$current,
						"annotations",
						lv_annotations_1_0,
						"com.yakindu.sct.model.stext.SText.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getStateSpecificationAccess().getScopeStateScopeParserRuleCall_2_0());
				}
				lv_scope_2_0=ruleStateScope
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStateSpecificationRule());
					}
					set(
						$current,
						"scope",
						lv_scope_2_0,
						"com.yakindu.sct.model.stext.SText.StateScope");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleTransitionSpecification
entryRuleTransitionSpecification returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTransitionSpecificationRule()); }
	iv_ruleTransitionSpecification=ruleTransitionSpecification
	{ $current=$iv_ruleTransitionSpecification.current; }
	EOF;

// Rule TransitionSpecification
ruleTransitionSpecification returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getTransitionSpecificationAccess().getReactionTransitionReactionParserRuleCall_0());
			}
			lv_reaction_0_0=ruleTransitionReaction
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getTransitionSpecificationRule());
				}
				set(
					$current,
					"reaction",
					lv_reaction_0_0,
					"com.yakindu.sct.model.stext.SText.TransitionReaction");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleStateScope
entryRuleStateScope returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStateScopeRule()); }
	iv_ruleStateScope=ruleStateScope
	{ $current=$iv_ruleStateScope.current; }
	EOF;

// Rule StateScope
ruleStateScope returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getStateScopeAccess().getSimpleScopeAction_0(),
					$current);
			}
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getStateScopeAccess().getMembersLocalReactionParserRuleCall_1_0_0());
					}
					lv_members_1_1=ruleLocalReaction
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getStateScopeRule());
						}
						add(
							$current,
							"members",
							lv_members_1_1,
							"com.yakindu.sct.model.stext.SText.LocalReaction");
						afterParserOrEnumRuleCall();
					}
					    |
					{
						newCompositeNode(grammarAccess.getStateScopeAccess().getMembersSubmachineReferenceExpressionParserRuleCall_1_0_1());
					}
					lv_members_1_2=ruleSubmachineReferenceExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getStateScopeRule());
						}
						add(
							$current,
							"members",
							lv_members_1_2,
							"com.yakindu.sct.model.stext.SText.SubmachineReferenceExpression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleStatechartScope
entryRuleStatechartScope returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStatechartScopeRule()); }
	iv_ruleStatechartScope=ruleStatechartScope
	{ $current=$iv_ruleStatechartScope.current; }
	EOF;

// Rule StatechartScope
ruleStatechartScope returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getStatechartScopeAccess().getInterfaceScopeParserRuleCall_0());
		}
		this_InterfaceScope_0=ruleInterfaceScope
		{
			$current = $this_InterfaceScope_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getStatechartScopeAccess().getInternalScopeParserRuleCall_1());
		}
		this_InternalScope_1=ruleInternalScope
		{
			$current = $this_InternalScope_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getStatechartScopeAccess().getImportScopeParserRuleCall_2());
		}
		this_ImportScope_2=ruleImportScope
		{
			$current = $this_ImportScope_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleInterfaceScope
entryRuleInterfaceScope returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getInterfaceScopeRule()); }
	iv_ruleInterfaceScope=ruleInterfaceScope
	{ $current=$iv_ruleInterfaceScope.current; }
	EOF;

// Rule InterfaceScope
ruleInterfaceScope returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getInterfaceScopeAccess().getInterfaceScopeAction_0(),
					$current);
			}
		)
		otherlv_1='interface'
		{
			newLeafNode(otherlv_1, grammarAccess.getInterfaceScopeAccess().getInterfaceKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getInterfaceScopeAccess().getNameIDWithKeywordsParserRuleCall_2_0());
				}
				lv_name_2_0=ruleIDWithKeywords
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getInterfaceScopeRule());
					}
					set(
						$current,
						"name",
						lv_name_2_0,
						"com.yakindu.base.expressions.Expressions.IDWithKeywords");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		otherlv_3=':'
		{
			newLeafNode(otherlv_3, grammarAccess.getInterfaceScopeAccess().getColonKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getInterfaceScopeAccess().getMembersScopeDeclarationParserRuleCall_4_0());
				}
				lv_members_4_0=ruleScopeDeclaration
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getInterfaceScopeRule());
					}
					add(
						$current,
						"members",
						lv_members_4_0,
						"com.yakindu.sct.model.stext.SText.ScopeDeclaration");
					afterParserOrEnumRuleCall();
				}
			)
		)*
	)
;

// Entry rule entryRuleScopeDeclaration
entryRuleScopeDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getScopeDeclarationRule()); }
	iv_ruleScopeDeclaration=ruleScopeDeclaration
	{ $current=$iv_ruleScopeDeclaration.current; }
	EOF;

// Rule ScopeDeclaration
ruleScopeDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getScopeDeclarationAccess().getAnnotatableElementAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getScopeDeclarationAccess().getAnnotationsAnnotationParserRuleCall_1_0());
				}
				lv_annotations_1_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
					}
					add(
						$current,
						"annotations",
						lv_annotations_1_0,
						"com.yakindu.sct.model.stext.SText.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getScopeDeclarationAccess().getVariableDefinitionAnnotationInfoAction_2_0_0(),
							$current);
					}
				)
				(
					(
						(
							lv_const_3_0='const'
							{
								newLeafNode(lv_const_3_0, grammarAccess.getScopeDeclarationAccess().getConstConstKeyword_2_0_1_0_0());
							}
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getScopeDeclarationRule());
								}
								setWithLastConsumed($current, "const", lv_const_3_0 != null, "const");
							}
						)
					)
					    |
					otherlv_4='var'
					{
						newLeafNode(otherlv_4, grammarAccess.getScopeDeclarationAccess().getVarKeyword_2_0_1_1());
					}
				)
				(
					(
						lv_readonly_5_0='readonly'
						{
							newLeafNode(lv_readonly_5_0, grammarAccess.getScopeDeclarationAccess().getReadonlyReadonlyKeyword_2_0_2_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getScopeDeclarationRule());
							}
							setWithLastConsumed($current, "readonly", lv_readonly_5_0 != null, "readonly");
						}
					)
				)?
				(
					(
						{
							newCompositeNode(grammarAccess.getScopeDeclarationAccess().getNameIDWithKeywordsParserRuleCall_2_0_3_0());
						}
						lv_name_6_0=ruleIDWithKeywords
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
							}
							set(
								$current,
								"name",
								lv_name_6_0,
								"com.yakindu.base.expressions.Expressions.IDWithKeywords");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						otherlv_7=':'
						{
							newLeafNode(otherlv_7, grammarAccess.getScopeDeclarationAccess().getColonKeyword_2_0_4_0_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getScopeDeclarationAccess().getTypeSpecifierTypeSpecifierParserRuleCall_2_0_4_0_1_0());
								}
								lv_typeSpecifier_8_0=ruleTypeSpecifier
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
									}
									set(
										$current,
										"typeSpecifier",
										lv_typeSpecifier_8_0,
										"com.yakindu.base.expressions.Expressions.TypeSpecifier");
									afterParserOrEnumRuleCall();
								}
							)
						)
						(
							otherlv_9='='
							{
								newLeafNode(otherlv_9, grammarAccess.getScopeDeclarationAccess().getEqualsSignKeyword_2_0_4_0_2_0());
							}
							(
								(
									{
										newCompositeNode(grammarAccess.getScopeDeclarationAccess().getInitialValueExpressionParserRuleCall_2_0_4_0_2_1_0());
									}
									lv_initialValue_10_0=ruleExpression
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
										}
										set(
											$current,
											"initialValue",
											lv_initialValue_10_0,
											"com.yakindu.base.expressions.Expressions.Expression");
										afterParserOrEnumRuleCall();
									}
								)
							)
						)?
					)
					    |
					(
						otherlv_11='='
						{
							newLeafNode(otherlv_11, grammarAccess.getScopeDeclarationAccess().getEqualsSignKeyword_2_0_4_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getScopeDeclarationAccess().getInitialValueExpressionParserRuleCall_2_0_4_1_1_0());
								}
								lv_initialValue_12_0=ruleExpression
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
									}
									set(
										$current,
										"initialValue",
										lv_initialValue_12_0,
										"com.yakindu.base.expressions.Expressions.Expression");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)
				)
			)
			    |
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getScopeDeclarationAccess().getEventDefinitionAnnotationInfoAction_2_1_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getScopeDeclarationAccess().getDirectionDirectionEnumRuleCall_2_1_1_0());
						}
						lv_direction_14_0=ruleDirection
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
							}
							set(
								$current,
								"direction",
								lv_direction_14_0,
								"com.yakindu.sct.model.stext.SText.Direction");
							afterParserOrEnumRuleCall();
						}
					)
				)?
				otherlv_15='event'
				{
					newLeafNode(otherlv_15, grammarAccess.getScopeDeclarationAccess().getEventKeyword_2_1_2());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getScopeDeclarationAccess().getNameIDWithKeywordsParserRuleCall_2_1_3_0());
						}
						lv_name_16_0=ruleIDWithKeywords
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
							}
							set(
								$current,
								"name",
								lv_name_16_0,
								"com.yakindu.base.expressions.Expressions.IDWithKeywords");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_17=':'
					{
						newLeafNode(otherlv_17, grammarAccess.getScopeDeclarationAccess().getColonKeyword_2_1_4_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getScopeDeclarationAccess().getTypeSpecifierTypeSpecifierParserRuleCall_2_1_4_1_0());
							}
							lv_typeSpecifier_18_0=ruleTypeSpecifier
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
								}
								set(
									$current,
									"typeSpecifier",
									lv_typeSpecifier_18_0,
									"com.yakindu.base.expressions.Expressions.TypeSpecifier");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)?
			)
			    |
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getScopeDeclarationAccess().getTypeAliasDefinitionAnnotationInfoAction_2_2_0(),
							$current);
					}
				)
				otherlv_20='alias'
				{
					newLeafNode(otherlv_20, grammarAccess.getScopeDeclarationAccess().getAliasKeyword_2_2_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getScopeDeclarationAccess().getNameIDWithKeywordsParserRuleCall_2_2_2_0());
						}
						lv_name_21_0=ruleIDWithKeywords
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
							}
							set(
								$current,
								"name",
								lv_name_21_0,
								"com.yakindu.base.expressions.Expressions.IDWithKeywords");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_22=':'
				{
					newLeafNode(otherlv_22, grammarAccess.getScopeDeclarationAccess().getColonKeyword_2_2_3());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getScopeDeclarationAccess().getTypeSpecifierTypeSpecifierParserRuleCall_2_2_4_0());
						}
						lv_typeSpecifier_23_0=ruleTypeSpecifier
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
							}
							set(
								$current,
								"typeSpecifier",
								lv_typeSpecifier_23_0,
								"com.yakindu.base.expressions.Expressions.TypeSpecifier");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			    |
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getScopeDeclarationAccess().getOperationDefinitionAnnotationInfoAction_2_3_0(),
							$current);
					}
				)
				otherlv_25='operation'
				{
					newLeafNode(otherlv_25, grammarAccess.getScopeDeclarationAccess().getOperationKeyword_2_3_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getScopeDeclarationAccess().getNameIDWithKeywordsParserRuleCall_2_3_2_0());
						}
						lv_name_26_0=ruleIDWithKeywords
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
							}
							set(
								$current,
								"name",
								lv_name_26_0,
								"com.yakindu.base.expressions.Expressions.IDWithKeywords");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_27='('
				{
					newLeafNode(otherlv_27, grammarAccess.getScopeDeclarationAccess().getLeftParenthesisKeyword_2_3_3());
				}
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getScopeDeclarationAccess().getParametersParameterParserRuleCall_2_3_4_0_0());
							}
							lv_parameters_28_0=ruleParameter
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
								}
								add(
									$current,
									"parameters",
									lv_parameters_28_0,
									"com.yakindu.sct.model.stext.SText.Parameter");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_29=','
						{
							newLeafNode(otherlv_29, grammarAccess.getScopeDeclarationAccess().getCommaKeyword_2_3_4_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getScopeDeclarationAccess().getParametersParameterParserRuleCall_2_3_4_1_1_0());
								}
								lv_parameters_30_0=ruleParameter
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
									}
									add(
										$current,
										"parameters",
										lv_parameters_30_0,
										"com.yakindu.sct.model.stext.SText.Parameter");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
				)?
				otherlv_31=')'
				{
					newLeafNode(otherlv_31, grammarAccess.getScopeDeclarationAccess().getRightParenthesisKeyword_2_3_5());
				}
				(
					otherlv_32=':'
					{
						newLeafNode(otherlv_32, grammarAccess.getScopeDeclarationAccess().getColonKeyword_2_3_6_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getScopeDeclarationAccess().getTypeSpecifierTypeSpecifierParserRuleCall_2_3_6_1_0());
							}
							lv_typeSpecifier_33_0=ruleTypeSpecifier
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getScopeDeclarationRule());
								}
								set(
									$current,
									"typeSpecifier",
									lv_typeSpecifier_33_0,
									"com.yakindu.base.expressions.Expressions.TypeSpecifier");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)?
			)
		)
	)
;

// Entry rule entryRuleInternalScope
entryRuleInternalScope returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getInternalScopeRule()); }
	iv_ruleInternalScope=ruleInternalScope
	{ $current=$iv_ruleInternalScope.current; }
	EOF;

// Rule InternalScope
ruleInternalScope returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getInternalScopeAccess().getInternalScopeAction_0(),
					$current);
			}
		)
		otherlv_1='internal'
		{
			newLeafNode(otherlv_1, grammarAccess.getInternalScopeAccess().getInternalKeyword_1());
		}
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getInternalScopeAccess().getColonKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getInternalScopeAccess().getMembersScopeDeclarationParserRuleCall_3_0_0());
					}
					lv_members_3_1=ruleScopeDeclaration
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getInternalScopeRule());
						}
						add(
							$current,
							"members",
							lv_members_3_1,
							"com.yakindu.sct.model.stext.SText.ScopeDeclaration");
						afterParserOrEnumRuleCall();
					}
					    |
					{
						newCompositeNode(grammarAccess.getInternalScopeAccess().getMembersLocalReactionParserRuleCall_3_0_1());
					}
					lv_members_3_2=ruleLocalReaction
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getInternalScopeRule());
						}
						add(
							$current,
							"members",
							lv_members_3_2,
							"com.yakindu.sct.model.stext.SText.LocalReaction");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleImportScope
entryRuleImportScope returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getImportScopeRule()); }
	iv_ruleImportScope=ruleImportScope
	{ $current=$iv_ruleImportScope.current; }
	EOF;

// Rule ImportScope
ruleImportScope returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getImportScopeAccess().getImportScopeAction_0(),
					$current);
			}
		)
		otherlv_1='import'
		{
			newLeafNode(otherlv_1, grammarAccess.getImportScopeAccess().getImportKeyword_1());
		}
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getImportScopeAccess().getColonKeyword_2());
		}
		(
			(
				lv_imports_3_0=RULE_STRING
				{
					newLeafNode(lv_imports_3_0, grammarAccess.getImportScopeAccess().getImportsSTRINGTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getImportScopeRule());
					}
					addWithLastConsumed(
						$current,
						"imports",
						lv_imports_3_0,
						"com.yakindu.base.expressions.Expressions.STRING");
				}
			)
		)*
	)
;

// Entry rule entryRuleSubmachineReferenceExpression
entryRuleSubmachineReferenceExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSubmachineReferenceExpressionRule()); }
	iv_ruleSubmachineReferenceExpression=ruleSubmachineReferenceExpression
	{ $current=$iv_ruleSubmachineReferenceExpression.current; }
	EOF;

// Rule SubmachineReferenceExpression
ruleSubmachineReferenceExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSubmachineReferenceExpressionAccess().getSubmachineReferenceExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='submachine'
		{
			newLeafNode(otherlv_1, grammarAccess.getSubmachineReferenceExpressionAccess().getSubmachineKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getSubmachineReferenceExpressionAccess().getSubmachineFeatureCallParserRuleCall_2_0());
				}
				lv_submachine_2_0=ruleFeatureCall
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSubmachineReferenceExpressionRule());
					}
					set(
						$current,
						"submachine",
						lv_submachine_2_0,
						"com.yakindu.base.expressions.Expressions.FeatureCall");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleAnnotation
entryRuleAnnotation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAnnotationRule()); }
	iv_ruleAnnotation=ruleAnnotation
	{ $current=$iv_ruleAnnotation.current; }
	EOF;

// Rule Annotation
ruleAnnotation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='@'
		{
			newLeafNode(otherlv_0, grammarAccess.getAnnotationAccess().getCommercialAtKeyword_0());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAnnotationRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getAnnotationAccess().getTypeAnnotationTypeCrossReference_1_0());
				}
				ruleQID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2='('
			{
				newLeafNode(otherlv_2, grammarAccess.getAnnotationAccess().getLeftParenthesisKeyword_2_0());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getAnnotationAccess().getArgumentsArgumentParserRuleCall_2_1_0_0());
						}
						lv_arguments_3_0=ruleArgument
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAnnotationRule());
							}
							add(
								$current,
								"arguments",
								lv_arguments_3_0,
								"com.yakindu.base.expressions.Expressions.Argument");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_4=','
					{
						newLeafNode(otherlv_4, grammarAccess.getAnnotationAccess().getCommaKeyword_2_1_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getAnnotationAccess().getArgumentsArgumentParserRuleCall_2_1_1_1_0());
							}
							lv_arguments_5_0=ruleArgument
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getAnnotationRule());
								}
								add(
									$current,
									"arguments",
									lv_arguments_5_0,
									"com.yakindu.base.expressions.Expressions.Argument");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			otherlv_6=')'
			{
				newLeafNode(otherlv_6, grammarAccess.getAnnotationAccess().getRightParenthesisKeyword_2_2());
			}
		)?
	)
;

// Entry rule entryRuleParameter
entryRuleParameter returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getParameterRule()); }
	iv_ruleParameter=ruleParameter
	{ $current=$iv_ruleParameter.current; }
	EOF;

// Rule Parameter
ruleParameter returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getParameterAccess().getNameIDWithKeywordsParserRuleCall_0_0());
				}
				lv_name_0_0=ruleIDWithKeywords
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getParameterRule());
					}
					set(
						$current,
						"name",
						lv_name_0_0,
						"com.yakindu.base.expressions.Expressions.IDWithKeywords");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				lv_varArgs_1_0='...'
				{
					newLeafNode(lv_varArgs_1_0, grammarAccess.getParameterAccess().getVarArgsFullStopFullStopFullStopKeyword_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getParameterRule());
					}
					setWithLastConsumed($current, "varArgs", lv_varArgs_1_0 != null, "...");
				}
			)
		)?
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getParameterAccess().getColonKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getParameterAccess().getTypeSpecifierTypeSpecifierParserRuleCall_3_0());
				}
				lv_typeSpecifier_3_0=ruleTypeSpecifier
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getParameterRule());
					}
					set(
						$current,
						"typeSpecifier",
						lv_typeSpecifier_3_0,
						"com.yakindu.base.expressions.Expressions.TypeSpecifier");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleLocalReaction
entryRuleLocalReaction returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLocalReactionRule()); }
	iv_ruleLocalReaction=ruleLocalReaction
	{ $current=$iv_ruleLocalReaction.current; }
	EOF;

// Rule LocalReaction
ruleLocalReaction returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getLocalReactionAccess().getTriggerReactionTriggerParserRuleCall_0_0());
				}
				lv_trigger_0_0=ruleReactionTrigger
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getLocalReactionRule());
					}
					set(
						$current,
						"trigger",
						lv_trigger_0_0,
						"com.yakindu.sct.model.stext.SText.ReactionTrigger");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			((
				'/'
				(
					(
						ruleReactionEffect
					)
				)
			)
			)=>
			(
				otherlv_1='/'
				{
					newLeafNode(otherlv_1, grammarAccess.getLocalReactionAccess().getSolidusKeyword_1_0_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLocalReactionAccess().getEffectReactionEffectParserRuleCall_1_0_1_0());
						}
						lv_effect_2_0=ruleReactionEffect
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLocalReactionRule());
							}
							set(
								$current,
								"effect",
								lv_effect_2_0,
								"com.yakindu.sct.model.stext.SText.ReactionEffect");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRuleTransitionReaction
entryRuleTransitionReaction returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTransitionReactionRule()); }
	iv_ruleTransitionReaction=ruleTransitionReaction
	{ $current=$iv_ruleTransitionReaction.current; }
	EOF;

// Rule TransitionReaction
ruleTransitionReaction returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getTransitionReactionAccess().getTransitionReactionAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getTransitionReactionAccess().getTriggerStextTriggerParserRuleCall_1_0());
				}
				lv_trigger_1_0=ruleStextTrigger
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTransitionReactionRule());
					}
					set(
						$current,
						"trigger",
						lv_trigger_1_0,
						"com.yakindu.sct.model.stext.SText.StextTrigger");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			((
				'/'
				(
					(
						ruleReactionEffect
					)
				)
			)
			)=>
			(
				otherlv_2='/'
				{
					newLeafNode(otherlv_2, grammarAccess.getTransitionReactionAccess().getSolidusKeyword_2_0_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getTransitionReactionAccess().getEffectReactionEffectParserRuleCall_2_0_1_0());
						}
						lv_effect_3_0=ruleReactionEffect
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getTransitionReactionRule());
							}
							set(
								$current,
								"effect",
								lv_effect_3_0,
								"com.yakindu.sct.model.stext.SText.ReactionEffect");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
		(
			otherlv_4='#'
			{
				newLeafNode(otherlv_4, grammarAccess.getTransitionReactionAccess().getNumberSignKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getTransitionReactionAccess().getPropertiesTransitionPropertyParserRuleCall_3_1_0());
					}
					lv_properties_5_0=ruleTransitionProperty
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getTransitionReactionRule());
						}
						add(
							$current,
							"properties",
							lv_properties_5_0,
							"com.yakindu.sct.model.stext.SText.TransitionProperty");
						afterParserOrEnumRuleCall();
					}
				)
			)*
		)?
	)
;

// Entry rule entryRuleStextTrigger
entryRuleStextTrigger returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStextTriggerRule()); }
	iv_ruleStextTrigger=ruleStextTrigger
	{ $current=$iv_ruleStextTrigger.current; }
	EOF;

// Rule StextTrigger
ruleStextTrigger returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getStextTriggerAccess().getReactionTriggerParserRuleCall_0());
		}
		this_ReactionTrigger_0=ruleReactionTrigger
		{
			$current = $this_ReactionTrigger_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getStextTriggerAccess().getDefaultTriggerParserRuleCall_1());
		}
		this_DefaultTrigger_1=ruleDefaultTrigger
		{
			$current = $this_DefaultTrigger_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleReactionTrigger
entryRuleReactionTrigger returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReactionTriggerRule()); }
	iv_ruleReactionTrigger=ruleReactionTrigger
	{ $current=$iv_ruleReactionTrigger.current; }
	EOF;

// Rule ReactionTrigger
ruleReactionTrigger returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getReactionTriggerAccess().getReactionTriggerAction_0(),
					$current);
			}
		)
		(
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getReactionTriggerAccess().getTriggersEventSpecParserRuleCall_1_0_0_0());
						}
						lv_triggers_1_0=ruleEventSpec
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReactionTriggerRule());
							}
							add(
								$current,
								"triggers",
								lv_triggers_1_0,
								"com.yakindu.sct.model.stext.SText.EventSpec");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_2=','
					{
						newLeafNode(otherlv_2, grammarAccess.getReactionTriggerAccess().getCommaKeyword_1_0_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getReactionTriggerAccess().getTriggersEventSpecParserRuleCall_1_0_1_1_0());
							}
							lv_triggers_3_0=ruleEventSpec
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getReactionTriggerRule());
								}
								add(
									$current,
									"triggers",
									lv_triggers_3_0,
									"com.yakindu.sct.model.stext.SText.EventSpec");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
				(
					(
						('[')=>
						otherlv_4='['
						{
							newLeafNode(otherlv_4, grammarAccess.getReactionTriggerAccess().getLeftSquareBracketKeyword_1_0_2_0());
						}
					)
					(
						(
							{
								newCompositeNode(grammarAccess.getReactionTriggerAccess().getGuardGuardParserRuleCall_1_0_2_1_0());
							}
							lv_guard_5_0=ruleGuard
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getReactionTriggerRule());
								}
								set(
									$current,
									"guard",
									lv_guard_5_0,
									"com.yakindu.sct.model.stext.SText.Guard");
								afterParserOrEnumRuleCall();
							}
						)
					)
					otherlv_6=']'
					{
						newLeafNode(otherlv_6, grammarAccess.getReactionTriggerAccess().getRightSquareBracketKeyword_1_0_2_2());
					}
				)?
			)
			    |
			(
				otherlv_7='['
				{
					newLeafNode(otherlv_7, grammarAccess.getReactionTriggerAccess().getLeftSquareBracketKeyword_1_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getReactionTriggerAccess().getGuardGuardParserRuleCall_1_1_1_0());
						}
						lv_guard_8_0=ruleGuard
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReactionTriggerRule());
							}
							set(
								$current,
								"guard",
								lv_guard_8_0,
								"com.yakindu.sct.model.stext.SText.Guard");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_9=']'
				{
					newLeafNode(otherlv_9, grammarAccess.getReactionTriggerAccess().getRightSquareBracketKeyword_1_1_2());
				}
			)
		)
	)
;

// Entry rule entryRuleDefaultTrigger
entryRuleDefaultTrigger returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDefaultTriggerRule()); }
	iv_ruleDefaultTrigger=ruleDefaultTrigger
	{ $current=$iv_ruleDefaultTrigger.current; }
	EOF;

// Rule DefaultTrigger
ruleDefaultTrigger returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDefaultTriggerAccess().getDefaultTriggerAction_0(),
					$current);
			}
		)
		(
			otherlv_1='default'
			{
				newLeafNode(otherlv_1, grammarAccess.getDefaultTriggerAccess().getDefaultKeyword_1_0());
			}
			    |
			otherlv_2='else'
			{
				newLeafNode(otherlv_2, grammarAccess.getDefaultTriggerAccess().getElseKeyword_1_1());
			}
		)
	)
;

// Entry rule entryRuleGuard
entryRuleGuard returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getGuardRule()); }
	iv_ruleGuard=ruleGuard
	{ $current=$iv_ruleGuard.current; }
	EOF;

// Rule Guard
ruleGuard returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getGuardAccess().getGuardAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getGuardAccess().getExpressionExpressionParserRuleCall_1_0());
				}
				lv_expression_1_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getGuardRule());
					}
					set(
						$current,
						"expression",
						lv_expression_1_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleReactionEffect
entryRuleReactionEffect returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReactionEffectRule()); }
	iv_ruleReactionEffect=ruleReactionEffect
	{ $current=$iv_ruleReactionEffect.current; }
	EOF;

// Rule ReactionEffect
ruleReactionEffect returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getReactionEffectAccess().getReactionEffectAction_0(),
					$current);
			}
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getReactionEffectAccess().getActionsExpressionParserRuleCall_1_0_0());
					}
					lv_actions_1_1=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getReactionEffectRule());
						}
						add(
							$current,
							"actions",
							lv_actions_1_1,
							"com.yakindu.base.expressions.Expressions.Expression");
						afterParserOrEnumRuleCall();
					}
					    |
					{
						newCompositeNode(grammarAccess.getReactionEffectAccess().getActionsEventRaisingExpressionParserRuleCall_1_0_1());
					}
					lv_actions_1_2=ruleEventRaisingExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getReactionEffectRule());
						}
						add(
							$current,
							"actions",
							lv_actions_1_2,
							"com.yakindu.base.expressions.Expressions.EventRaisingExpression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		(
			(
				(';')=>
				otherlv_2=';'
				{
					newLeafNode(otherlv_2, grammarAccess.getReactionEffectAccess().getSemicolonKeyword_2_0());
				}
			)
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getReactionEffectAccess().getActionsExpressionParserRuleCall_2_1_0_0());
						}
						lv_actions_3_1=ruleExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReactionEffectRule());
							}
							add(
								$current,
								"actions",
								lv_actions_3_1,
								"com.yakindu.base.expressions.Expressions.Expression");
							afterParserOrEnumRuleCall();
						}
						    |
						{
							newCompositeNode(grammarAccess.getReactionEffectAccess().getActionsEventRaisingExpressionParserRuleCall_2_1_0_1());
						}
						lv_actions_3_2=ruleEventRaisingExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReactionEffectRule());
							}
							add(
								$current,
								"actions",
								lv_actions_3_2,
								"com.yakindu.base.expressions.Expressions.EventRaisingExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleTransitionProperty
entryRuleTransitionProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTransitionPropertyRule()); }
	iv_ruleTransitionProperty=ruleTransitionProperty
	{ $current=$iv_ruleTransitionProperty.current; }
	EOF;

// Rule TransitionProperty
ruleTransitionProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTransitionPropertyAccess().getEntryPointSpecParserRuleCall_0());
		}
		this_EntryPointSpec_0=ruleEntryPointSpec
		{
			$current = $this_EntryPointSpec_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTransitionPropertyAccess().getExitPointSpecParserRuleCall_1());
		}
		this_ExitPointSpec_1=ruleExitPointSpec
		{
			$current = $this_ExitPointSpec_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleEntryPointSpec
entryRuleEntryPointSpec returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEntryPointSpecRule()); }
	iv_ruleEntryPointSpec=ruleEntryPointSpec
	{ $current=$iv_ruleEntryPointSpec.current; }
	EOF;

// Rule EntryPointSpec
ruleEntryPointSpec returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='>'
		{
			newLeafNode(otherlv_0, grammarAccess.getEntryPointSpecAccess().getGreaterThanSignKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEntryPointSpecAccess().getEntrypointIDWithKeywordsParserRuleCall_1_0());
				}
				lv_entrypoint_1_0=ruleIDWithKeywords
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEntryPointSpecRule());
					}
					set(
						$current,
						"entrypoint",
						lv_entrypoint_1_0,
						"com.yakindu.base.expressions.Expressions.IDWithKeywords");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleExitPointSpec
entryRuleExitPointSpec returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExitPointSpecRule()); }
	iv_ruleExitPointSpec=ruleExitPointSpec
	{ $current=$iv_ruleExitPointSpec.current; }
	EOF;

// Rule ExitPointSpec
ruleExitPointSpec returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getExitPointSpecAccess().getExitpointIDWithKeywordsParserRuleCall_0_0());
				}
				lv_exitpoint_0_0=ruleIDWithKeywords
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getExitPointSpecRule());
					}
					set(
						$current,
						"exitpoint",
						lv_exitpoint_0_0,
						"com.yakindu.base.expressions.Expressions.IDWithKeywords");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1='>'
		{
			newLeafNode(otherlv_1, grammarAccess.getExitPointSpecAccess().getGreaterThanSignKeyword_1());
		}
	)
;

// Entry rule entryRuleEventSpec
entryRuleEventSpec returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEventSpecRule()); }
	iv_ruleEventSpec=ruleEventSpec
	{ $current=$iv_ruleEventSpec.current; }
	EOF;

// Rule EventSpec
ruleEventSpec returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getEventSpecAccess().getRegularEventSpecParserRuleCall_0());
		}
		this_RegularEventSpec_0=ruleRegularEventSpec
		{
			$current = $this_RegularEventSpec_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getEventSpecAccess().getTimeEventSpecParserRuleCall_1());
		}
		this_TimeEventSpec_1=ruleTimeEventSpec
		{
			$current = $this_TimeEventSpec_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getEventSpecAccess().getBuiltinEventSpecParserRuleCall_2());
		}
		this_BuiltinEventSpec_2=ruleBuiltinEventSpec
		{
			$current = $this_BuiltinEventSpec_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleRegularEventSpec
entryRuleRegularEventSpec returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRegularEventSpecRule()); }
	iv_ruleRegularEventSpec=ruleRegularEventSpec
	{ $current=$iv_ruleRegularEventSpec.current; }
	EOF;

// Rule RegularEventSpec
ruleRegularEventSpec returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getRegularEventSpecAccess().getEventSimpleFeatureCallParserRuleCall_0());
			}
			lv_event_0_0=ruleSimpleFeatureCall
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getRegularEventSpecRule());
				}
				set(
					$current,
					"event",
					lv_event_0_0,
					"com.yakindu.sct.model.stext.SText.SimpleFeatureCall");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleSimpleFeatureCall
entryRuleSimpleFeatureCall returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSimpleFeatureCallRule()); }
	iv_ruleSimpleFeatureCall=ruleSimpleFeatureCall
	{ $current=$iv_ruleSimpleFeatureCall.current; }
	EOF;

// Rule SimpleFeatureCall
ruleSimpleFeatureCall returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getSimpleFeatureCallAccess().getSimpleElementReferenceExpressionParserRuleCall_0());
		}
		this_SimpleElementReferenceExpression_0=ruleSimpleElementReferenceExpression
		{
			$current = $this_SimpleElementReferenceExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			(
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getSimpleFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0(),
								$current);
						}
					)
					otherlv_2='.'
					{
						newLeafNode(otherlv_2, grammarAccess.getSimpleFeatureCallAccess().getFullStopKeyword_1_0_0_1());
					}
				)
				    |
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getSimpleFeatureCallAccess().getMetaCallOwnerAction_1_0_1_0(),
								$current);
						}
					)
					otherlv_4='.@'
					{
						newLeafNode(otherlv_4, grammarAccess.getSimpleFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_1_1());
					}
				)
			)
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSimpleFeatureCallRule());
						}
					}
					otherlv_5=RULE_ID
					{
						newLeafNode(otherlv_5, grammarAccess.getSimpleFeatureCallAccess().getFeatureDeclarationCrossReference_1_1_0());
					}
				)
			)
			(
				(
					((
						'('
					)
					)=>
					(
						lv_operationCall_6_0='('
						{
							newLeafNode(lv_operationCall_6_0, grammarAccess.getSimpleFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_2_0_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getSimpleFeatureCallRule());
							}
							setWithLastConsumed($current, "operationCall", lv_operationCall_6_0 != null, "(");
						}
					)
				)
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getSimpleFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_2_1_0_0());
							}
							lv_arguments_7_0=ruleArgument
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getSimpleFeatureCallRule());
								}
								add(
									$current,
									"arguments",
									lv_arguments_7_0,
									"com.yakindu.base.expressions.Expressions.Argument");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_8=','
						{
							newLeafNode(otherlv_8, grammarAccess.getSimpleFeatureCallAccess().getCommaKeyword_1_2_1_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getSimpleFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_2_1_1_1_0());
								}
								lv_arguments_9_0=ruleArgument
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getSimpleFeatureCallRule());
									}
									add(
										$current,
										"arguments",
										lv_arguments_9_0,
										"com.yakindu.base.expressions.Expressions.Argument");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
				)?
				otherlv_10=')'
				{
					newLeafNode(otherlv_10, grammarAccess.getSimpleFeatureCallAccess().getRightParenthesisKeyword_1_2_2());
				}
			)?
		)*
	)
;

// Entry rule entryRuleSimpleElementReferenceExpression
entryRuleSimpleElementReferenceExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSimpleElementReferenceExpressionRule()); }
	iv_ruleSimpleElementReferenceExpression=ruleSimpleElementReferenceExpression
	{ $current=$iv_ruleSimpleElementReferenceExpression.current; }
	EOF;

// Rule SimpleElementReferenceExpression
ruleSimpleElementReferenceExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSimpleElementReferenceExpressionRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getSimpleElementReferenceExpressionAccess().getReferenceEObjectCrossReference_0_0());
				}
			)
		)
		(
			(
				((
					'('
				)
				)=>
				(
					lv_operationCall_1_0='('
					{
						newLeafNode(lv_operationCall_1_0, grammarAccess.getSimpleElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_1_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSimpleElementReferenceExpressionRule());
						}
						setWithLastConsumed($current, "operationCall", lv_operationCall_1_0 != null, "(");
					}
				)
			)
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_1_1_0_0());
						}
						lv_arguments_2_0=ruleArgument
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSimpleElementReferenceExpressionRule());
							}
							add(
								$current,
								"arguments",
								lv_arguments_2_0,
								"com.yakindu.base.expressions.Expressions.Argument");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_3=','
					{
						newLeafNode(otherlv_3, grammarAccess.getSimpleElementReferenceExpressionAccess().getCommaKeyword_1_1_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_1_1_1_1_0());
							}
							lv_arguments_4_0=ruleArgument
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getSimpleElementReferenceExpressionRule());
								}
								add(
									$current,
									"arguments",
									lv_arguments_4_0,
									"com.yakindu.base.expressions.Expressions.Argument");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			otherlv_5=')'
			{
				newLeafNode(otherlv_5, grammarAccess.getSimpleElementReferenceExpressionAccess().getRightParenthesisKeyword_1_2());
			}
		)?
	)
;

// Entry rule entryRuleTimeEventSpec
entryRuleTimeEventSpec returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTimeEventSpecRule()); }
	iv_ruleTimeEventSpec=ruleTimeEventSpec
	{ $current=$iv_ruleTimeEventSpec.current; }
	EOF;

// Rule TimeEventSpec
ruleTimeEventSpec returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getTimeEventSpecAccess().getTypeTimeEventTypeEnumRuleCall_0_0());
				}
				lv_type_0_0=ruleTimeEventType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTimeEventSpecRule());
					}
					set(
						$current,
						"type",
						lv_type_0_0,
						"com.yakindu.sct.model.stext.SText.TimeEventType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getTimeEventSpecAccess().getValueConditionalExpressionParserRuleCall_1_0());
				}
				lv_value_1_0=ruleConditionalExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTimeEventSpecRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.ConditionalExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getTimeEventSpecAccess().getUnitTimeUnitEnumRuleCall_2_0());
				}
				lv_unit_2_0=ruleTimeUnit
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTimeEventSpecRule());
					}
					set(
						$current,
						"unit",
						lv_unit_2_0,
						"com.yakindu.sct.model.stext.SText.TimeUnit");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleBuiltinEventSpec
entryRuleBuiltinEventSpec returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBuiltinEventSpecRule()); }
	iv_ruleBuiltinEventSpec=ruleBuiltinEventSpec
	{ $current=$iv_ruleBuiltinEventSpec.current; }
	EOF;

// Rule BuiltinEventSpec
ruleBuiltinEventSpec returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBuiltinEventSpecAccess().getEntryEventParserRuleCall_0());
		}
		this_EntryEvent_0=ruleEntryEvent
		{
			$current = $this_EntryEvent_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getBuiltinEventSpecAccess().getExitEventParserRuleCall_1());
		}
		this_ExitEvent_1=ruleExitEvent
		{
			$current = $this_ExitEvent_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getBuiltinEventSpecAccess().getAlwaysEventParserRuleCall_2());
		}
		this_AlwaysEvent_2=ruleAlwaysEvent
		{
			$current = $this_AlwaysEvent_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleEntryEvent
entryRuleEntryEvent returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEntryEventRule()); }
	iv_ruleEntryEvent=ruleEntryEvent
	{ $current=$iv_ruleEntryEvent.current; }
	EOF;

// Rule EntryEvent
ruleEntryEvent returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEntryEventAccess().getEntryEventAction_0(),
					$current);
			}
		)
		otherlv_1='entry'
		{
			newLeafNode(otherlv_1, grammarAccess.getEntryEventAccess().getEntryKeyword_1());
		}
	)
;

// Entry rule entryRuleExitEvent
entryRuleExitEvent returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExitEventRule()); }
	iv_ruleExitEvent=ruleExitEvent
	{ $current=$iv_ruleExitEvent.current; }
	EOF;

// Rule ExitEvent
ruleExitEvent returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getExitEventAccess().getExitEventAction_0(),
					$current);
			}
		)
		otherlv_1='exit'
		{
			newLeafNode(otherlv_1, grammarAccess.getExitEventAccess().getExitKeyword_1());
		}
	)
;

// Entry rule entryRuleAlwaysEvent
entryRuleAlwaysEvent returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAlwaysEventRule()); }
	iv_ruleAlwaysEvent=ruleAlwaysEvent
	{ $current=$iv_ruleAlwaysEvent.current; }
	EOF;

// Rule AlwaysEvent
ruleAlwaysEvent returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAlwaysEventAccess().getAlwaysEventAction_0(),
					$current);
			}
		)
		(
			otherlv_1='always'
			{
				newLeafNode(otherlv_1, grammarAccess.getAlwaysEventAccess().getAlwaysKeyword_1_0());
			}
			    |
			otherlv_2='oncycle'
			{
				newLeafNode(otherlv_2, grammarAccess.getAlwaysEventAccess().getOncycleKeyword_1_1());
			}
		)
	)
;

// Entry rule entryRuleActiveStateReferenceExpression
entryRuleActiveStateReferenceExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getActiveStateReferenceExpressionRule()); }
	iv_ruleActiveStateReferenceExpression=ruleActiveStateReferenceExpression
	{ $current=$iv_ruleActiveStateReferenceExpression.current; }
	EOF;

// Rule ActiveStateReferenceExpression
ruleActiveStateReferenceExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getActiveStateReferenceExpressionAccess().getActiveStateReferenceExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='active'
		{
			newLeafNode(otherlv_1, grammarAccess.getActiveStateReferenceExpressionAccess().getActiveKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getActiveStateReferenceExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getActiveStateReferenceExpressionRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getActiveStateReferenceExpressionAccess().getValueRegularStateCrossReference_3_0());
				}
				ruleFQN
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getActiveStateReferenceExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRulePrimaryExpression
entryRulePrimaryExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimaryExpressionRule()); }
	iv_rulePrimaryExpression=rulePrimaryExpression
	{ $current=$iv_rulePrimaryExpression.current; }
	EOF;

// Rule PrimaryExpression
rulePrimaryExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getElementReferenceExpressionParserRuleCall_0());
		}
		this_ElementReferenceExpression_0=ruleElementReferenceExpression
		{
			$current = $this_ElementReferenceExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getPrimitiveValueExpressionParserRuleCall_1());
		}
		this_PrimitiveValueExpression_1=rulePrimitiveValueExpression
		{
			$current = $this_PrimitiveValueExpression_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getActiveStateReferenceExpressionParserRuleCall_2());
		}
		this_ActiveStateReferenceExpression_2=ruleActiveStateReferenceExpression
		{
			$current = $this_ActiveStateReferenceExpression_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getEventValueReferenceExpressionParserRuleCall_3());
		}
		this_EventValueReferenceExpression_3=ruleEventValueReferenceExpression
		{
			$current = $this_EventValueReferenceExpression_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getParenthesizedExpressionParserRuleCall_4());
		}
		this_ParenthesizedExpression_4=ruleParenthesizedExpression
		{
			$current = $this_ParenthesizedExpression_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getInitializationExpressionParserRuleCall_5());
		}
		this_InitializationExpression_5=ruleInitializationExpression
		{
			$current = $this_InitializationExpression_5.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleReferenceKeywords
entryRuleReferenceKeywords returns [String current=null]:
	{ newCompositeNode(grammarAccess.getReferenceKeywordsRule()); }
	iv_ruleReferenceKeywords=ruleReferenceKeywords
	{ $current=$iv_ruleReferenceKeywords.current.getText(); }
	EOF;

// Rule ReferenceKeywords
ruleReferenceKeywords returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='as'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getAsKeyword_0());
		}
		    |
		kw='default'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getDefaultKeyword_1());
		}
		    |
		kw='else'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getElseKeyword_2());
		}
		    |
		kw='every'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getEveryKeyword_3());
		}
		    |
		kw='always'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getAlwaysKeyword_4());
		}
		    |
		kw='oncycle'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getOncycleKeyword_5());
		}
		    |
		kw='after'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getAfterKeyword_6());
		}
		    |
		kw='exit'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getExitKeyword_7());
		}
		    |
		kw='entry'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getEntryKeyword_8());
		}
		    |
		kw='namespace'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getNamespaceKeyword_9());
		}
		    |
		kw='interface'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getInterfaceKeyword_10());
		}
		    |
		kw='internal'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getInternalKeyword_11());
		}
		    |
		kw='import'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getImportKeyword_12());
		}
		    |
		kw='event'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getEventKeyword_13());
		}
		    |
		kw='local'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getLocalKeyword_14());
		}
		    |
		kw='in'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getInKeyword_15());
		}
		    |
		kw='out'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getOutKeyword_16());
		}
		    |
		kw='const'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getConstKeyword_17());
		}
		    |
		kw='var'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getVarKeyword_18());
		}
		    |
		kw='readonly'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getReadonlyKeyword_19());
		}
		    |
		kw='operation'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getOperationKeyword_20());
		}
		    |
		kw='alias'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getAliasKeyword_21());
		}
		    |
		kw='s'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getSKeyword_22());
		}
		    |
		kw='ms'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getMsKeyword_23());
		}
		    |
		kw='us'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getUsKeyword_24());
		}
		    |
		kw='ns'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getNsKeyword_25());
		}
		    |
		kw='submachine'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getSubmachineKeyword_26());
		}
	)
;

// Entry rule entryRuleOtherKeywords
entryRuleOtherKeywords returns [String current=null]:
	{ newCompositeNode(grammarAccess.getOtherKeywordsRule()); }
	iv_ruleOtherKeywords=ruleOtherKeywords
	{ $current=$iv_ruleOtherKeywords.current.getText(); }
	EOF;

// Rule OtherKeywords
ruleOtherKeywords returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='raise'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getRaiseKeyword_0());
		}
		    |
		kw='valueof'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getValueofKeyword_1());
		}
		    |
		kw='active'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getActiveKeyword_2());
		}
	)
;

// Entry rule entryRuleFQN
entryRuleFQN returns [String current=null]:
	{ newCompositeNode(grammarAccess.getFQNRule()); }
	iv_ruleFQN=ruleFQN
	{ $current=$iv_ruleFQN.current.getText(); }
	EOF;

// Rule FQN
ruleFQN returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getFQNAccess().getIDWithKeywordsParserRuleCall_0());
		}
		this_IDWithKeywords_0=ruleIDWithKeywords
		{
			$current.merge(this_IDWithKeywords_0);
		}
		{
			afterParserOrEnumRuleCall();
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getFQNAccess().getFullStopKeyword_1_0());
			}
			{
				newCompositeNode(grammarAccess.getFQNAccess().getIDWithKeywordsParserRuleCall_1_1());
			}
			this_IDWithKeywords_2=ruleIDWithKeywords
			{
				$current.merge(this_IDWithKeywords_2);
			}
			{
				afterParserOrEnumRuleCall();
			}
		)*
	)
;

// Entry rule entryRuleExpression
entryRuleExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExpressionRule()); }
	iv_ruleExpression=ruleExpression
	{ $current=$iv_ruleExpression.current; }
	EOF;

// Rule Expression
ruleExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	{
		newCompositeNode(grammarAccess.getExpressionAccess().getAssignmentExpressionParserRuleCall());
	}
	this_AssignmentExpression_0=ruleAssignmentExpression
	{
		$current = $this_AssignmentExpression_0.current;
		afterParserOrEnumRuleCall();
	}
;

// Entry rule entryRuleAssignmentExpression
entryRuleAssignmentExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAssignmentExpressionRule()); }
	iv_ruleAssignmentExpression=ruleAssignmentExpression
	{ $current=$iv_ruleAssignmentExpression.current; }
	EOF;

// Rule AssignmentExpression
ruleAssignmentExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getAssignmentExpressionAccess().getConditionalExpressionParserRuleCall_0());
		}
		this_ConditionalExpression_0=ruleConditionalExpression
		{
			$current = $this_ConditionalExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleAssignmentOperator
					)
				)
				(
					(
						ruleConditionalExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionVarRefAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignmentOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleAssignmentOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAssignmentExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.AssignmentOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getAssignmentExpressionAccess().getExpressionConditionalExpressionParserRuleCall_1_0_2_0());
						}
						lv_expression_3_0=ruleConditionalExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAssignmentExpressionRule());
							}
							set(
								$current,
								"expression",
								lv_expression_3_0,
								"com.yakindu.base.expressions.Expressions.ConditionalExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleConditionalExpression
entryRuleConditionalExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConditionalExpressionRule()); }
	iv_ruleConditionalExpression=ruleConditionalExpression
	{ $current=$iv_ruleConditionalExpression.current; }
	EOF;

// Rule ConditionalExpression
ruleConditionalExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getConditionalExpressionAccess().getLogicalOrExpressionParserRuleCall_0());
		}
		this_LogicalOrExpression_0=ruleLogicalOrExpression
		{
			$current = $this_LogicalOrExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				'?'
				(
					(
						ruleLogicalOrExpression
					)
				)
				':'
				(
					(
						ruleLogicalOrExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getConditionalExpressionAccess().getConditionalExpressionConditionAction_1_0_0(),
							$current);
					}
				)
				otherlv_2='?'
				{
					newLeafNode(otherlv_2, grammarAccess.getConditionalExpressionAccess().getQuestionMarkKeyword_1_0_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConditionalExpressionAccess().getTrueCaseLogicalOrExpressionParserRuleCall_1_0_2_0());
						}
						lv_trueCase_3_0=ruleLogicalOrExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConditionalExpressionRule());
							}
							set(
								$current,
								"trueCase",
								lv_trueCase_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalOrExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_4=':'
				{
					newLeafNode(otherlv_4, grammarAccess.getConditionalExpressionAccess().getColonKeyword_1_0_3());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConditionalExpressionAccess().getFalseCaseLogicalOrExpressionParserRuleCall_1_0_4_0());
						}
						lv_falseCase_5_0=ruleLogicalOrExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConditionalExpressionRule());
							}
							set(
								$current,
								"falseCase",
								lv_falseCase_5_0,
								"com.yakindu.base.expressions.Expressions.LogicalOrExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleLogicalOrExpression
entryRuleLogicalOrExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalOrExpressionRule()); }
	iv_ruleLogicalOrExpression=ruleLogicalOrExpression
	{ $current=$iv_ruleLogicalOrExpression.current; }
	EOF;

// Rule LogicalOrExpression
ruleLogicalOrExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalOrExpressionAccess().getLogicalAndExpressionParserRuleCall_0());
		}
		this_LogicalAndExpression_0=ruleLogicalAndExpression
		{
			$current = $this_LogicalAndExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleLogicalOrOperator
				(
					(
						ruleLogicalAndExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getLogicalOrExpressionAccess().getLogicalOrExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrOperatorParserRuleCall_1_0_1());
				}
				ruleLogicalOrOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalOrExpressionAccess().getRightOperandLogicalAndExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleLogicalAndExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalOrExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalAndExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleLogicalAndExpression
entryRuleLogicalAndExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalAndExpressionRule()); }
	iv_ruleLogicalAndExpression=ruleLogicalAndExpression
	{ $current=$iv_ruleLogicalAndExpression.current; }
	EOF;

// Rule LogicalAndExpression
ruleLogicalAndExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalAndExpressionAccess().getLogicalNotExpressionParserRuleCall_0());
		}
		this_LogicalNotExpression_0=ruleLogicalNotExpression
		{
			$current = $this_LogicalNotExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleLogicalAndOperator
				(
					(
						ruleLogicalNotExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getLogicalAndExpressionAccess().getLogicalAndExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndOperatorParserRuleCall_1_0_1());
				}
				ruleLogicalAndOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalAndExpressionAccess().getRightOperandLogicalNotExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleLogicalNotExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalAndExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalNotExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleLogicalNotExpression
entryRuleLogicalNotExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalNotExpressionRule()); }
	iv_ruleLogicalNotExpression=ruleLogicalNotExpression
	{ $current=$iv_ruleLogicalNotExpression.current; }
	EOF;

// Rule LogicalNotExpression
ruleLogicalNotExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalNotExpressionAccess().getBitwiseOrExpressionParserRuleCall_0());
		}
		this_BitwiseOrExpression_0=ruleBitwiseOrExpression
		{
			$current = $this_BitwiseOrExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			((
				(
				)
				ruleLogicalNotOperator
				(
					(
						ruleBitwiseOrExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElement(
							grammarAccess.getLogicalNotExpressionAccess().getLogicalNotExpressionAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotOperatorParserRuleCall_1_0_1());
				}
				ruleLogicalNotOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalNotExpressionAccess().getOperandBitwiseOrExpressionParserRuleCall_1_0_2_0());
						}
						lv_operand_3_0=ruleBitwiseOrExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalNotExpressionRule());
							}
							set(
								$current,
								"operand",
								lv_operand_3_0,
								"com.yakindu.base.expressions.Expressions.BitwiseOrExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRuleBitwiseOrExpression
entryRuleBitwiseOrExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseOrExpressionRule()); }
	iv_ruleBitwiseOrExpression=ruleBitwiseOrExpression
	{ $current=$iv_ruleBitwiseOrExpression.current; }
	EOF;

// Rule BitwiseOrExpression
ruleBitwiseOrExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseXorExpressionParserRuleCall_0());
		}
		this_BitwiseXorExpression_0=ruleBitwiseXorExpression
		{
			$current = $this_BitwiseXorExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleBitwiseOrOperator
				(
					(
						ruleBitwiseXorExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrOperatorParserRuleCall_1_0_1());
				}
				ruleBitwiseOrOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandBitwiseXorExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleBitwiseXorExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getBitwiseOrExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.BitwiseXorExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleBitwiseXorExpression
entryRuleBitwiseXorExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseXorExpressionRule()); }
	iv_ruleBitwiseXorExpression=ruleBitwiseXorExpression
	{ $current=$iv_ruleBitwiseXorExpression.current; }
	EOF;

// Rule BitwiseXorExpression
ruleBitwiseXorExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseAndExpressionParserRuleCall_0());
		}
		this_BitwiseAndExpression_0=ruleBitwiseAndExpression
		{
			$current = $this_BitwiseAndExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleBitwiseXOrOperator
				(
					(
						ruleBitwiseAndExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXorExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXOrOperatorParserRuleCall_1_0_1());
				}
				ruleBitwiseXOrOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandBitwiseAndExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleBitwiseAndExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getBitwiseXorExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.BitwiseAndExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleBitwiseAndExpression
entryRuleBitwiseAndExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseAndExpressionRule()); }
	iv_ruleBitwiseAndExpression=ruleBitwiseAndExpression
	{ $current=$iv_ruleBitwiseAndExpression.current; }
	EOF;

// Rule BitwiseAndExpression
ruleBitwiseAndExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBitwiseAndExpressionAccess().getLogicalRelationExpressionParserRuleCall_0());
		}
		this_LogicalRelationExpression_0=ruleLogicalRelationExpression
		{
			$current = $this_LogicalRelationExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleBitwiseAndOperator
				(
					(
						ruleLogicalRelationExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndOperatorParserRuleCall_1_0_1());
				}
				ruleBitwiseAndOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandLogicalRelationExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleLogicalRelationExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getBitwiseAndExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalRelationExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleLogicalRelationExpression
entryRuleLogicalRelationExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalRelationExpressionRule()); }
	iv_ruleLogicalRelationExpression=ruleLogicalRelationExpression
	{ $current=$iv_ruleLogicalRelationExpression.current; }
	EOF;

// Rule LogicalRelationExpression
ruleLogicalRelationExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalRelationExpressionAccess().getShiftExpressionParserRuleCall_0());
		}
		this_ShiftExpression_0=ruleShiftExpression
		{
			$current = $this_ShiftExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleRelationalOperator
					)
				)
				(
					(
						ruleShiftExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getLogicalRelationExpressionAccess().getLogicalRelationExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalRelationExpressionAccess().getOperatorRelationalOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleRelationalOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalRelationExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.RelationalOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandShiftExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleShiftExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalRelationExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.ShiftExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleShiftExpression
entryRuleShiftExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getShiftExpressionRule()); }
	iv_ruleShiftExpression=ruleShiftExpression
	{ $current=$iv_ruleShiftExpression.current; }
	EOF;

// Rule ShiftExpression
ruleShiftExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getShiftExpressionAccess().getNumericalAddSubtractExpressionParserRuleCall_0());
		}
		this_NumericalAddSubtractExpression_0=ruleNumericalAddSubtractExpression
		{
			$current = $this_NumericalAddSubtractExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleShiftOperator
					)
				)
				(
					(
						ruleNumericalAddSubtractExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getShiftExpressionAccess().getShiftExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getShiftExpressionAccess().getOperatorShiftOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleShiftOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getShiftExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.ShiftOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getShiftExpressionAccess().getRightOperandNumericalAddSubtractExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleNumericalAddSubtractExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getShiftExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.NumericalAddSubtractExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleNumericalAddSubtractExpression
entryRuleNumericalAddSubtractExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionRule()); }
	iv_ruleNumericalAddSubtractExpression=ruleNumericalAddSubtractExpression
	{ $current=$iv_ruleNumericalAddSubtractExpression.current; }
	EOF;

// Rule NumericalAddSubtractExpression
ruleNumericalAddSubtractExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalMultiplyDivideExpressionParserRuleCall_0());
		}
		this_NumericalMultiplyDivideExpression_0=ruleNumericalMultiplyDivideExpression
		{
			$current = $this_NumericalMultiplyDivideExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleAdditiveOperator
					)
				)
				(
					(
						ruleNumericalMultiplyDivideExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalAddSubtractExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAdditiveOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleAdditiveOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalAddSubtractExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.AdditiveOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandNumericalMultiplyDivideExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleNumericalMultiplyDivideExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalAddSubtractExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.NumericalMultiplyDivideExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleNumericalMultiplyDivideExpression
entryRuleNumericalMultiplyDivideExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionRule()); }
	iv_ruleNumericalMultiplyDivideExpression=ruleNumericalMultiplyDivideExpression
	{ $current=$iv_ruleNumericalMultiplyDivideExpression.current; }
	EOF;

// Rule NumericalMultiplyDivideExpression
ruleNumericalMultiplyDivideExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalUnaryExpressionParserRuleCall_0());
		}
		this_NumericalUnaryExpression_0=ruleNumericalUnaryExpression
		{
			$current = $this_NumericalUnaryExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleMultiplicativeOperator
					)
				)
				(
					(
						ruleNumericalUnaryExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalMultiplyDivideExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorMultiplicativeOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleMultiplicativeOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalMultiplyDivideExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.MultiplicativeOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandNumericalUnaryExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleNumericalUnaryExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalMultiplyDivideExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.NumericalUnaryExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleNumericalUnaryExpression
entryRuleNumericalUnaryExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNumericalUnaryExpressionRule()); }
	iv_ruleNumericalUnaryExpression=ruleNumericalUnaryExpression
	{ $current=$iv_ruleNumericalUnaryExpression.current; }
	EOF;

// Rule NumericalUnaryExpression
ruleNumericalUnaryExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNumericalUnaryExpressionAccess().getPostFixUnaryExpressionParserRuleCall_0());
		}
		this_PostFixUnaryExpression_0=rulePostFixUnaryExpression
		{
			$current = $this_PostFixUnaryExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			((
				(
				)
				(
					(
						ruleUnaryOperator
					)
				)
				(
					(
						rulePostFixUnaryExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElement(
							grammarAccess.getNumericalUnaryExpressionAccess().getNumericalUnaryExpressionAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorUnaryOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleUnaryOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalUnaryExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.UnaryOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalUnaryExpressionAccess().getOperandPostFixUnaryExpressionParserRuleCall_1_0_2_0());
						}
						lv_operand_3_0=rulePostFixUnaryExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalUnaryExpressionRule());
							}
							set(
								$current,
								"operand",
								lv_operand_3_0,
								"com.yakindu.base.expressions.Expressions.PostFixUnaryExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRulePostFixUnaryExpression
entryRulePostFixUnaryExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPostFixUnaryExpressionRule()); }
	iv_rulePostFixUnaryExpression=rulePostFixUnaryExpression
	{ $current=$iv_rulePostFixUnaryExpression.current; }
	EOF;

// Rule PostFixUnaryExpression
rulePostFixUnaryExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPostFixUnaryExpressionAccess().getTypeCastExpressionParserRuleCall_0());
		}
		this_TypeCastExpression_0=ruleTypeCastExpression
		{
			$current = $this_TypeCastExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						rulePostFixOperator
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getPostFixUnaryExpressionAccess().getPostFixUnaryExpressionOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorPostFixOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=rulePostFixOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getPostFixUnaryExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.PostFixOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleTypeCastExpression
entryRuleTypeCastExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypeCastExpressionRule()); }
	iv_ruleTypeCastExpression=ruleTypeCastExpression
	{ $current=$iv_ruleTypeCastExpression.current; }
	EOF;

// Rule TypeCastExpression
ruleTypeCastExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTypeCastExpressionAccess().getFeatureCallParserRuleCall_0());
		}
		this_FeatureCall_0=ruleFeatureCall
		{
			$current = $this_FeatureCall_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
					(
					)
					'as'
				)
				(
					(
						ruleTypeSpecifier
					)
				)
			)
			)=>
			(
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getTypeCastExpressionAccess().getTypeCastExpressionOperandAction_1_0_0_0(),
								$current);
						}
					)
					otherlv_2='as'
					{
						newLeafNode(otherlv_2, grammarAccess.getTypeCastExpressionAccess().getAsKeyword_1_0_0_1());
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_1_0_1_0());
						}
						lv_typeSpecifier_3_0=ruleTypeSpecifier
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getTypeCastExpressionRule());
							}
							set(
								$current,
								"typeSpecifier",
								lv_typeSpecifier_3_0,
								"com.yakindu.base.expressions.Expressions.TypeSpecifier");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleFeatureCall
entryRuleFeatureCall returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFeatureCallRule()); }
	iv_ruleFeatureCall=ruleFeatureCall
	{ $current=$iv_ruleFeatureCall.current; }
	EOF;

// Rule FeatureCall
ruleFeatureCall returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getFeatureCallAccess().getPrimaryExpressionParserRuleCall_0());
		}
		this_PrimaryExpression_0=rulePrimaryExpression
		{
			$current = $this_PrimaryExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
					(
						(
						)
						(
							('.')=>
							'.'
						)
					)
					    |
					(
						(
						)
						'.@'
					)
				)
				(
					(
						ruleRefIDWithKeywords
					)
				)
				(
					(
						(
							((
								'('
							)
							)=>
							(
								'('
							)
						)
						(
							(
								(
									ruleArgument
								)
							)
							(
								','
								(
									(
										ruleArgument
									)
								)
							)*
						)?
						')'
					)
					    |
					(
						(
							((
								(
									(
										'['
									)
								)
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								(
									(
										'['
									)
								)
								(
									(
										ruleExpression
									)
								)
								']'
							)
						)
						(
							((
								'['
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								'['
								(
									(
										ruleExpression
									)
								)
								']'
							)
						)*
					)
				)?
			)
			)=>
			(
				(
					(
						(
							{
								$current = forceCreateModelElementAndSet(
									grammarAccess.getFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0_0(),
									$current);
							}
						)
						(
							('.')=>
							otherlv_2='.'
							{
								newLeafNode(otherlv_2, grammarAccess.getFeatureCallAccess().getFullStopKeyword_1_0_0_0_1());
							}
						)
					)
					    |
					(
						(
							{
								$current = forceCreateModelElementAndSet(
									grammarAccess.getFeatureCallAccess().getMetaCallOwnerAction_1_0_0_1_0(),
									$current);
							}
						)
						otherlv_4='.@'
						{
							newLeafNode(otherlv_4, grammarAccess.getFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_0_1_1());
						}
					)
				)
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getFeatureCallRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getFeatureCallAccess().getFeatureEObjectCrossReference_1_0_1_0());
						}
						ruleRefIDWithKeywords
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						(
							((
								'('
							)
							)=>
							(
								lv_operationCall_6_0='('
								{
									newLeafNode(lv_operationCall_6_0, grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0());
								}
								{
									if ($current==null) {
										$current = createModelElement(grammarAccess.getFeatureCallRule());
									}
									setWithLastConsumed($current, "operationCall", lv_operationCall_6_0 != null, "(");
								}
							)
						)
						(
							(
								(
									{
										newCompositeNode(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_0_0());
									}
									lv_arguments_7_0=ruleArgument
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
										}
										add(
											$current,
											"arguments",
											lv_arguments_7_0,
											"com.yakindu.base.expressions.Expressions.Argument");
										afterParserOrEnumRuleCall();
									}
								)
							)
							(
								otherlv_8=','
								{
									newLeafNode(otherlv_8, grammarAccess.getFeatureCallAccess().getCommaKeyword_1_0_2_0_1_1_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_1_1_0());
										}
										lv_arguments_9_0=ruleArgument
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
											}
											add(
												$current,
												"arguments",
												lv_arguments_9_0,
												"com.yakindu.base.expressions.Expressions.Argument");
											afterParserOrEnumRuleCall();
										}
									)
								)
							)*
						)?
						otherlv_10=')'
						{
							newLeafNode(otherlv_10, grammarAccess.getFeatureCallAccess().getRightParenthesisKeyword_1_0_2_0_2());
						}
					)
					    |
					(
						(
							((
								(
									(
										'['
									)
								)
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								(
									(
										lv_arrayAccess_11_0='['
										{
											newLeafNode(lv_arrayAccess_11_0, grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getFeatureCallRule());
											}
											setWithLastConsumed($current, "arrayAccess", lv_arrayAccess_11_0 != null, "[");
										}
									)
								)
								(
									(
										{
											newCompositeNode(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_0_0_1_0());
										}
										lv_arraySelector_12_0=ruleExpression
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
											}
											add(
												$current,
												"arraySelector",
												lv_arraySelector_12_0,
												"com.yakindu.base.expressions.Expressions.Expression");
											afterParserOrEnumRuleCall();
										}
									)
								)
								otherlv_13=']'
								{
									newLeafNode(otherlv_13, grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_0_0_2());
								}
							)
						)
						(
							((
								'['
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								otherlv_14='['
								{
									newLeafNode(otherlv_14, grammarAccess.getFeatureCallAccess().getLeftSquareBracketKeyword_1_0_2_1_1_0_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_1_0_1_0());
										}
										lv_arraySelector_15_0=ruleExpression
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
											}
											add(
												$current,
												"arraySelector",
												lv_arraySelector_15_0,
												"com.yakindu.base.expressions.Expressions.Expression");
											afterParserOrEnumRuleCall();
										}
									)
								)
								otherlv_16=']'
								{
									newLeafNode(otherlv_16, grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_1_0_2());
								}
							)
						)*
					)
				)?
			)
		)*
	)
;

// Entry rule entryRuleElementReferenceExpression
entryRuleElementReferenceExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getElementReferenceExpressionRule()); }
	iv_ruleElementReferenceExpression=ruleElementReferenceExpression
	{ $current=$iv_ruleElementReferenceExpression.current; }
	EOF;

// Rule ElementReferenceExpression
ruleElementReferenceExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getElementReferenceExpressionAccess().getElementReferenceExpressionAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getElementReferenceExpressionRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectCrossReference_1_0());
				}
				ruleRefIDWithKeywords
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(
					((
						'('
					)
					)=>
					(
						lv_operationCall_2_0='('
						{
							newLeafNode(lv_operationCall_2_0, grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getElementReferenceExpressionRule());
							}
							setWithLastConsumed($current, "operationCall", lv_operationCall_2_0 != null, "(");
						}
					)
				)
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_0_0());
							}
							lv_arguments_3_0=ruleArgument
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
								}
								add(
									$current,
									"arguments",
									lv_arguments_3_0,
									"com.yakindu.base.expressions.Expressions.Argument");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_4=','
						{
							newLeafNode(otherlv_4, grammarAccess.getElementReferenceExpressionAccess().getCommaKeyword_2_0_1_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_1_1_0());
								}
								lv_arguments_5_0=ruleArgument
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
									}
									add(
										$current,
										"arguments",
										lv_arguments_5_0,
										"com.yakindu.base.expressions.Expressions.Argument");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
				)?
				otherlv_6=')'
				{
					newLeafNode(otherlv_6, grammarAccess.getElementReferenceExpressionAccess().getRightParenthesisKeyword_2_0_2());
				}
			)
			    |
			(
				(
					((
						(
							(
								'['
							)
						)
						(
							(
								ruleExpression
							)
						)
						']'
					)
					)=>
					(
						(
							(
								lv_arrayAccess_7_0='['
								{
									newLeafNode(lv_arrayAccess_7_0, grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0());
								}
								{
									if ($current==null) {
										$current = createModelElement(grammarAccess.getElementReferenceExpressionRule());
									}
									setWithLastConsumed($current, "arrayAccess", lv_arrayAccess_7_0 != null, "[");
								}
							)
						)
						(
							(
								{
									newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_0_0_1_0());
								}
								lv_arraySelector_8_0=ruleExpression
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
									}
									add(
										$current,
										"arraySelector",
										lv_arraySelector_8_0,
										"com.yakindu.base.expressions.Expressions.Expression");
									afterParserOrEnumRuleCall();
								}
							)
						)
						otherlv_9=']'
						{
							newLeafNode(otherlv_9, grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_0_0_2());
						}
					)
				)
				(
					((
						'['
						(
							(
								ruleExpression
							)
						)
						']'
					)
					)=>
					(
						otherlv_10='['
						{
							newLeafNode(otherlv_10, grammarAccess.getElementReferenceExpressionAccess().getLeftSquareBracketKeyword_2_1_1_0_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_1_0_1_0());
								}
								lv_arraySelector_11_0=ruleExpression
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
									}
									add(
										$current,
										"arraySelector",
										lv_arraySelector_11_0,
										"com.yakindu.base.expressions.Expressions.Expression");
									afterParserOrEnumRuleCall();
								}
							)
						)
						otherlv_12=']'
						{
							newLeafNode(otherlv_12, grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_1_0_2());
						}
					)
				)*
			)
		)?
	)
;

// Entry rule entryRulePrimitiveValueExpression
entryRulePrimitiveValueExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimitiveValueExpressionRule()); }
	iv_rulePrimitiveValueExpression=rulePrimitiveValueExpression
	{ $current=$iv_rulePrimitiveValueExpression.current; }
	EOF;

// Rule PrimitiveValueExpression
rulePrimitiveValueExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPrimitiveValueExpressionAccess().getPrimitiveValueExpressionAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getPrimitiveValueExpressionAccess().getValueLiteralParserRuleCall_1_0());
				}
				lv_value_1_0=ruleLiteral
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPrimitiveValueExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.Literal");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleEventRaisingExpression
entryRuleEventRaisingExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEventRaisingExpressionRule()); }
	iv_ruleEventRaisingExpression=ruleEventRaisingExpression
	{ $current=$iv_ruleEventRaisingExpression.current; }
	EOF;

// Rule EventRaisingExpression
ruleEventRaisingExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEventRaisingExpressionAccess().getEventRaisingExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='raise'
		{
			newLeafNode(otherlv_1, grammarAccess.getEventRaisingExpressionAccess().getRaiseKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEventRaisingExpressionAccess().getEventFeatureCallParserRuleCall_2_0());
				}
				lv_event_2_0=ruleFeatureCall
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEventRaisingExpressionRule());
					}
					set(
						$current,
						"event",
						lv_event_2_0,
						"com.yakindu.base.expressions.Expressions.FeatureCall");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(':')=>
				otherlv_3=':'
				{
					newLeafNode(otherlv_3, grammarAccess.getEventRaisingExpressionAccess().getColonKeyword_3_0());
				}
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getEventRaisingExpressionAccess().getValueExpressionParserRuleCall_3_1_0());
					}
					lv_value_4_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEventRaisingExpressionRule());
						}
						set(
							$current,
							"value",
							lv_value_4_0,
							"com.yakindu.base.expressions.Expressions.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleEventValueReferenceExpression
entryRuleEventValueReferenceExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEventValueReferenceExpressionRule()); }
	iv_ruleEventValueReferenceExpression=ruleEventValueReferenceExpression
	{ $current=$iv_ruleEventValueReferenceExpression.current; }
	EOF;

// Rule EventValueReferenceExpression
ruleEventValueReferenceExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEventValueReferenceExpressionAccess().getEventValueReferenceExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='valueof'
		{
			newLeafNode(otherlv_1, grammarAccess.getEventValueReferenceExpressionAccess().getValueofKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getEventValueReferenceExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEventValueReferenceExpressionAccess().getValueFeatureCallParserRuleCall_3_0());
				}
				lv_value_3_0=ruleFeatureCall
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEventValueReferenceExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"com.yakindu.base.expressions.Expressions.FeatureCall");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getEventValueReferenceExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleInitializationExpression
entryRuleInitializationExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getInitializationExpressionRule()); }
	iv_ruleInitializationExpression=ruleInitializationExpression
	{ $current=$iv_ruleInitializationExpression.current; }
	EOF;

// Rule InitializationExpression
ruleInitializationExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getInitializationExpressionAccess().getInitializationExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='{'
		{
			newLeafNode(otherlv_1, grammarAccess.getInitializationExpressionAccess().getLeftCurlyBracketKeyword_1());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_0());
					}
					lv_arguments_2_0=ruleArgument
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getInitializationExpressionRule());
						}
						add(
							$current,
							"arguments",
							lv_arguments_2_0,
							"com.yakindu.base.expressions.Expressions.Argument");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_3=','
				{
					newLeafNode(otherlv_3, grammarAccess.getInitializationExpressionAccess().getCommaKeyword_2_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_1_1_0());
						}
						lv_arguments_4_0=ruleArgument
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getInitializationExpressionRule());
							}
							add(
								$current,
								"arguments",
								lv_arguments_4_0,
								"com.yakindu.base.expressions.Expressions.Argument");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_5='}'
		{
			newLeafNode(otherlv_5, grammarAccess.getInitializationExpressionAccess().getRightCurlyBracketKeyword_3());
		}
	)
;

// Entry rule entryRuleArgument
entryRuleArgument returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getArgumentRule()); }
	iv_ruleArgument=ruleArgument
	{ $current=$iv_ruleArgument.current; }
	EOF;

// Rule Argument
ruleArgument returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getArgumentRule());
						}
					}
					otherlv_0=RULE_ID
					{
						newLeafNode(otherlv_0, grammarAccess.getArgumentAccess().getParameterTypedDeclarationCrossReference_0_0_0());
					}
				)
			)
			otherlv_1='='
			{
				newLeafNode(otherlv_1, grammarAccess.getArgumentAccess().getEqualsSignKeyword_0_1());
			}
		)?
		(
			((
				(
					(
						rulePrimitiveValueExpression
					)
				)
				':'
			)
			)=>
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getArgumentAccess().getKeyPrimitiveValueExpressionParserRuleCall_1_0_0_0());
						}
						lv_key_2_0=rulePrimitiveValueExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getArgumentRule());
							}
							set(
								$current,
								"key",
								lv_key_2_0,
								"com.yakindu.base.expressions.Expressions.PrimitiveValueExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_3=':'
				{
					newLeafNode(otherlv_3, grammarAccess.getArgumentAccess().getColonKeyword_1_0_1());
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getArgumentAccess().getValueConditionalExpressionParserRuleCall_2_0());
				}
				lv_value_4_0=ruleConditionalExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getArgumentRule());
					}
					set(
						$current,
						"value",
						lv_value_4_0,
						"com.yakindu.base.expressions.Expressions.ConditionalExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleParenthesizedExpression
entryRuleParenthesizedExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getParenthesizedExpressionRule()); }
	iv_ruleParenthesizedExpression=ruleParenthesizedExpression
	{ $current=$iv_ruleParenthesizedExpression.current; }
	EOF;

// Rule ParenthesizedExpression
ruleParenthesizedExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getParenthesizedExpressionAccess().getParenthesizedExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getParenthesizedExpressionAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getParenthesizedExpressionAccess().getExpressionExpressionParserRuleCall_2_0());
				}
				lv_expression_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getParenthesizedExpressionRule());
					}
					set(
						$current,
						"expression",
						lv_expression_2_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3=')'
		{
			newLeafNode(otherlv_3, grammarAccess.getParenthesizedExpressionAccess().getRightParenthesisKeyword_3());
		}
	)
;

// Entry rule entryRuleTypeSpecifier
entryRuleTypeSpecifier returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypeSpecifierRule()); }
	iv_ruleTypeSpecifier=ruleTypeSpecifier
	{ $current=$iv_ruleTypeSpecifier.current; }
	EOF;

// Rule TypeSpecifier
ruleTypeSpecifier returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getTypeSpecifierRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getTypeSpecifierAccess().getTypeTypeCrossReference_0_0());
				}
				ruleQID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			((
				'<'
				(
					(
						(
							ruleTypeSpecifier
						)
					)
					(
						','
						(
							(
								ruleTypeSpecifier
							)
						)
					)*
				)?
				'>'
			)
			)=>
			(
				otherlv_1='<'
				{
					newLeafNode(otherlv_1, grammarAccess.getTypeSpecifierAccess().getLessThanSignKeyword_1_0_0());
				}
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_0_0());
							}
							lv_typeArguments_2_0=ruleTypeSpecifier
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getTypeSpecifierRule());
								}
								add(
									$current,
									"typeArguments",
									lv_typeArguments_2_0,
									"com.yakindu.base.expressions.Expressions.TypeSpecifier");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_3=','
						{
							newLeafNode(otherlv_3, grammarAccess.getTypeSpecifierAccess().getCommaKeyword_1_0_1_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_1_1_0());
								}
								lv_typeArguments_4_0=ruleTypeSpecifier
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getTypeSpecifierRule());
									}
									add(
										$current,
										"typeArguments",
										lv_typeArguments_4_0,
										"com.yakindu.base.expressions.Expressions.TypeSpecifier");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
				)?
				otherlv_5='>'
				{
					newLeafNode(otherlv_5, grammarAccess.getTypeSpecifierAccess().getGreaterThanSignKeyword_1_0_2());
				}
			)
		)?
	)
;

// Entry rule entryRuleQID
entryRuleQID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getQIDRule()); }
	iv_ruleQID=ruleQID
	{ $current=$iv_ruleQID.current.getText(); }
	EOF;

// Rule QID
ruleQID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getQIDAccess().getIDTerminalRuleCall_0());
		}
		(
			(
				('.')=>
				kw='.'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getQIDAccess().getFullStopKeyword_1_0());
				}
			)
			this_ID_2=RULE_ID
			{
				$current.merge(this_ID_2);
			}
			{
				newLeafNode(this_ID_2, grammarAccess.getQIDAccess().getIDTerminalRuleCall_1_1());
			}
		)*
	)
;

// Entry rule entryRuleIDWithKeywords
entryRuleIDWithKeywords returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIDWithKeywordsRule()); }
	iv_ruleIDWithKeywords=ruleIDWithKeywords
	{ $current=$iv_ruleIDWithKeywords.current.getText(); }
	EOF;

// Rule IDWithKeywords
ruleIDWithKeywords returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getIDWithKeywordsAccess().getIDTerminalRuleCall_0());
		}
		    |
		{
			newCompositeNode(grammarAccess.getIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1());
		}
		this_ReferenceKeywords_1=ruleReferenceKeywords
		{
			$current.merge(this_ReferenceKeywords_1);
		}
		{
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getIDWithKeywordsAccess().getOtherKeywordsParserRuleCall_2());
		}
		this_OtherKeywords_2=ruleOtherKeywords
		{
			$current.merge(this_OtherKeywords_2);
		}
		{
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleRefIDWithKeywords
entryRuleRefIDWithKeywords returns [String current=null]:
	{ newCompositeNode(grammarAccess.getRefIDWithKeywordsRule()); }
	iv_ruleRefIDWithKeywords=ruleRefIDWithKeywords
	{ $current=$iv_ruleRefIDWithKeywords.current.getText(); }
	EOF;

// Rule RefIDWithKeywords
ruleRefIDWithKeywords returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getRefIDWithKeywordsAccess().getIDTerminalRuleCall_0());
		}
		    |
		{
			newCompositeNode(grammarAccess.getRefIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1());
		}
		this_ReferenceKeywords_1=ruleReferenceKeywords
		{
			$current.merge(this_ReferenceKeywords_1);
		}
		{
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleLiteral
entryRuleLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLiteralRule()); }
	iv_ruleLiteral=ruleLiteral
	{ $current=$iv_ruleLiteral.current; }
	EOF;

// Rule Literal
ruleLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getBoolLiteralParserRuleCall_0());
		}
		this_BoolLiteral_0=ruleBoolLiteral
		{
			$current = $this_BoolLiteral_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getIntLiteralParserRuleCall_1());
		}
		this_IntLiteral_1=ruleIntLiteral
		{
			$current = $this_IntLiteral_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getHexLiteralParserRuleCall_2());
		}
		this_HexLiteral_2=ruleHexLiteral
		{
			$current = $this_HexLiteral_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getBinaryLiteralParserRuleCall_3());
		}
		this_BinaryLiteral_3=ruleBinaryLiteral
		{
			$current = $this_BinaryLiteral_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getDoubleLiteralParserRuleCall_4());
		}
		this_DoubleLiteral_4=ruleDoubleLiteral
		{
			$current = $this_DoubleLiteral_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getFloatLiteralParserRuleCall_5());
		}
		this_FloatLiteral_5=ruleFloatLiteral
		{
			$current = $this_FloatLiteral_5.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_6());
		}
		this_StringLiteral_6=ruleStringLiteral
		{
			$current = $this_StringLiteral_6.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_7());
		}
		this_NullLiteral_7=ruleNullLiteral
		{
			$current = $this_NullLiteral_7.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleBoolLiteral
entryRuleBoolLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBoolLiteralRule()); }
	iv_ruleBoolLiteral=ruleBoolLiteral
	{ $current=$iv_ruleBoolLiteral.current; }
	EOF;

// Rule BoolLiteral
ruleBoolLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getBoolLiteralAccess().getBoolLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_BOOL
				{
					newLeafNode(lv_value_1_0, grammarAccess.getBoolLiteralAccess().getValueBOOLTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getBoolLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.BOOL");
				}
			)
		)
	)
;

// Entry rule entryRuleIntLiteral
entryRuleIntLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIntLiteralRule()); }
	iv_ruleIntLiteral=ruleIntLiteral
	{ $current=$iv_ruleIntLiteral.current; }
	EOF;

// Rule IntLiteral
ruleIntLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getIntLiteralAccess().getIntLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_LONG
				{
					newLeafNode(lv_value_1_0, grammarAccess.getIntLiteralAccess().getValueLONGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIntLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.LONG");
				}
			)
		)
	)
;

// Entry rule entryRuleDoubleLiteral
entryRuleDoubleLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDoubleLiteralRule()); }
	iv_ruleDoubleLiteral=ruleDoubleLiteral
	{ $current=$iv_ruleDoubleLiteral.current; }
	EOF;

// Rule DoubleLiteral
ruleDoubleLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDoubleLiteralAccess().getDoubleLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_DOUBLE
				{
					newLeafNode(lv_value_1_0, grammarAccess.getDoubleLiteralAccess().getValueDOUBLETerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDoubleLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.DOUBLE");
				}
			)
		)
	)
;

// Entry rule entryRuleFloatLiteral
entryRuleFloatLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFloatLiteralRule()); }
	iv_ruleFloatLiteral=ruleFloatLiteral
	{ $current=$iv_ruleFloatLiteral.current; }
	EOF;

// Rule FloatLiteral
ruleFloatLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getFloatLiteralAccess().getFloatLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_FLOAT
				{
					newLeafNode(lv_value_1_0, grammarAccess.getFloatLiteralAccess().getValueFLOATTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFloatLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.FLOAT");
				}
			)
		)
	)
;

// Entry rule entryRuleHexLiteral
entryRuleHexLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getHexLiteralRule()); }
	iv_ruleHexLiteral=ruleHexLiteral
	{ $current=$iv_ruleHexLiteral.current; }
	EOF;

// Rule HexLiteral
ruleHexLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getHexLiteralAccess().getHexLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_HEX
				{
					newLeafNode(lv_value_1_0, grammarAccess.getHexLiteralAccess().getValueHEXTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getHexLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.HEX");
				}
			)
		)
	)
;

// Entry rule entryRuleBinaryLiteral
entryRuleBinaryLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBinaryLiteralRule()); }
	iv_ruleBinaryLiteral=ruleBinaryLiteral
	{ $current=$iv_ruleBinaryLiteral.current; }
	EOF;

// Rule BinaryLiteral
ruleBinaryLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getBinaryLiteralAccess().getBinaryLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_BINARY
				{
					newLeafNode(lv_value_1_0, grammarAccess.getBinaryLiteralAccess().getValueBINARYTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getBinaryLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.BINARY");
				}
			)
		)
	)
;

// Entry rule entryRuleStringLiteral
entryRuleStringLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStringLiteralRule()); }
	iv_ruleStringLiteral=ruleStringLiteral
	{ $current=$iv_ruleStringLiteral.current; }
	EOF;

// Rule StringLiteral
ruleStringLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getStringLiteralAccess().getStringLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_STRING
				{
					newLeafNode(lv_value_1_0, grammarAccess.getStringLiteralAccess().getValueSTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStringLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.STRING");
				}
			)
		)
	)
;

// Entry rule entryRuleNullLiteral
entryRuleNullLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNullLiteralRule()); }
	iv_ruleNullLiteral=ruleNullLiteral
	{ $current=$iv_ruleNullLiteral.current; }
	EOF;

// Rule NullLiteral
ruleNullLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getNullLiteralAccess().getNullLiteralAction_0(),
					$current);
			}
		)
		otherlv_1='null'
		{
			newLeafNode(otherlv_1, grammarAccess.getNullLiteralAccess().getNullKeyword_1());
		}
	)
;

// Entry rule entryRuleLogicalAndOperator
entryRuleLogicalAndOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getLogicalAndOperatorRule()); }
	iv_ruleLogicalAndOperator=ruleLogicalAndOperator
	{ $current=$iv_ruleLogicalAndOperator.current.getText(); }
	EOF;

// Rule LogicalAndOperator
ruleLogicalAndOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='&&'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getLogicalAndOperatorAccess().getAmpersandAmpersandKeyword());
	}
;

// Entry rule entryRuleLogicalOrOperator
entryRuleLogicalOrOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getLogicalOrOperatorRule()); }
	iv_ruleLogicalOrOperator=ruleLogicalOrOperator
	{ $current=$iv_ruleLogicalOrOperator.current.getText(); }
	EOF;

// Rule LogicalOrOperator
ruleLogicalOrOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='||'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getLogicalOrOperatorAccess().getVerticalLineVerticalLineKeyword());
	}
;

// Entry rule entryRuleLogicalNotOperator
entryRuleLogicalNotOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getLogicalNotOperatorRule()); }
	iv_ruleLogicalNotOperator=ruleLogicalNotOperator
	{ $current=$iv_ruleLogicalNotOperator.current.getText(); }
	EOF;

// Rule LogicalNotOperator
ruleLogicalNotOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='!'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getLogicalNotOperatorAccess().getExclamationMarkKeyword());
	}
;

// Entry rule entryRuleBitwiseXOrOperator
entryRuleBitwiseXOrOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseXOrOperatorRule()); }
	iv_ruleBitwiseXOrOperator=ruleBitwiseXOrOperator
	{ $current=$iv_ruleBitwiseXOrOperator.current.getText(); }
	EOF;

// Rule BitwiseXOrOperator
ruleBitwiseXOrOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='^'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getBitwiseXOrOperatorAccess().getCircumflexAccentKeyword());
	}
;

// Entry rule entryRuleBitwiseOrOperator
entryRuleBitwiseOrOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseOrOperatorRule()); }
	iv_ruleBitwiseOrOperator=ruleBitwiseOrOperator
	{ $current=$iv_ruleBitwiseOrOperator.current.getText(); }
	EOF;

// Rule BitwiseOrOperator
ruleBitwiseOrOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='|'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getBitwiseOrOperatorAccess().getVerticalLineKeyword());
	}
;

// Entry rule entryRuleBitwiseAndOperator
entryRuleBitwiseAndOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseAndOperatorRule()); }
	iv_ruleBitwiseAndOperator=ruleBitwiseAndOperator
	{ $current=$iv_ruleBitwiseAndOperator.current.getText(); }
	EOF;

// Rule BitwiseAndOperator
ruleBitwiseAndOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='&'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getBitwiseAndOperatorAccess().getAmpersandKeyword());
	}
;

// Rule Direction
ruleDirection returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='in'
			{
				$current = grammarAccess.getDirectionAccess().getINEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getDirectionAccess().getINEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='out'
			{
				$current = grammarAccess.getDirectionAccess().getOUTEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getDirectionAccess().getOUTEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule TimeEventType
ruleTimeEventType returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='after'
			{
				$current = grammarAccess.getTimeEventTypeAccess().getAfterEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getTimeEventTypeAccess().getAfterEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='every'
			{
				$current = grammarAccess.getTimeEventTypeAccess().getEveryEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getTimeEventTypeAccess().getEveryEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule TimeUnit
ruleTimeUnit returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='s'
			{
				$current = grammarAccess.getTimeUnitAccess().getSecondEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getTimeUnitAccess().getSecondEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='ms'
			{
				$current = grammarAccess.getTimeUnitAccess().getMillisecondEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getTimeUnitAccess().getMillisecondEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='us'
			{
				$current = grammarAccess.getTimeUnitAccess().getMicrosecondEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getTimeUnitAccess().getMicrosecondEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='ns'
			{
				$current = grammarAccess.getTimeUnitAccess().getNanosecondEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getTimeUnitAccess().getNanosecondEnumLiteralDeclaration_3());
			}
		)
	)
;

// Rule PostFixOperator
rulePostFixOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='++'
			{
				$current = grammarAccess.getPostFixOperatorAccess().getIncrementEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getPostFixOperatorAccess().getIncrementEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='--'
			{
				$current = grammarAccess.getPostFixOperatorAccess().getDecrementEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getPostFixOperatorAccess().getDecrementEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule AssignmentOperator
ruleAssignmentOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getAssignEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getAssignmentOperatorAccess().getAssignEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='*='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getMultAssignEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getAssignmentOperatorAccess().getMultAssignEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='/='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getDivAssignEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getAssignmentOperatorAccess().getDivAssignEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='%='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getModAssignEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getAssignmentOperatorAccess().getModAssignEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='+='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getAddAssignEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getAssignmentOperatorAccess().getAddAssignEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='-='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getSubAssignEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getAssignmentOperatorAccess().getSubAssignEnumLiteralDeclaration_5());
			}
		)
		    |
		(
			enumLiteral_6='<<='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getLeftShiftAssignEnumLiteralDeclaration_6().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_6, grammarAccess.getAssignmentOperatorAccess().getLeftShiftAssignEnumLiteralDeclaration_6());
			}
		)
		    |
		(
			enumLiteral_7='>>='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getRightShiftAssignEnumLiteralDeclaration_7().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_7, grammarAccess.getAssignmentOperatorAccess().getRightShiftAssignEnumLiteralDeclaration_7());
			}
		)
		    |
		(
			enumLiteral_8='&='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getAndAssignEnumLiteralDeclaration_8().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_8, grammarAccess.getAssignmentOperatorAccess().getAndAssignEnumLiteralDeclaration_8());
			}
		)
		    |
		(
			enumLiteral_9='^='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getXorAssignEnumLiteralDeclaration_9().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_9, grammarAccess.getAssignmentOperatorAccess().getXorAssignEnumLiteralDeclaration_9());
			}
		)
		    |
		(
			enumLiteral_10='|='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getOrAssignEnumLiteralDeclaration_10().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_10, grammarAccess.getAssignmentOperatorAccess().getOrAssignEnumLiteralDeclaration_10());
			}
		)
	)
;

// Rule ShiftOperator
ruleShiftOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='<<'
			{
				$current = grammarAccess.getShiftOperatorAccess().getLeftEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getShiftOperatorAccess().getLeftEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='>>'
			{
				$current = grammarAccess.getShiftOperatorAccess().getRightEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getShiftOperatorAccess().getRightEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule AdditiveOperator
ruleAdditiveOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='+'
			{
				$current = grammarAccess.getAdditiveOperatorAccess().getPlusEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getAdditiveOperatorAccess().getPlusEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='-'
			{
				$current = grammarAccess.getAdditiveOperatorAccess().getMinusEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getAdditiveOperatorAccess().getMinusEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule MultiplicativeOperator
ruleMultiplicativeOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='*'
			{
				$current = grammarAccess.getMultiplicativeOperatorAccess().getMulEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getMultiplicativeOperatorAccess().getMulEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='/'
			{
				$current = grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='%'
			{
				$current = grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2());
			}
		)
	)
;

// Rule UnaryOperator
ruleUnaryOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='+'
			{
				$current = grammarAccess.getUnaryOperatorAccess().getPositiveEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getUnaryOperatorAccess().getPositiveEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='-'
			{
				$current = grammarAccess.getUnaryOperatorAccess().getNegativeEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getUnaryOperatorAccess().getNegativeEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='~'
			{
				$current = grammarAccess.getUnaryOperatorAccess().getComplementEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getUnaryOperatorAccess().getComplementEnumLiteralDeclaration_2());
			}
		)
	)
;

// Rule RelationalOperator
ruleRelationalOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='<'
			{
				$current = grammarAccess.getRelationalOperatorAccess().getSmallerEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getRelationalOperatorAccess().getSmallerEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='<='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getSmallerEqualEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getRelationalOperatorAccess().getSmallerEqualEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='>'
			{
				$current = grammarAccess.getRelationalOperatorAccess().getGreaterEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getRelationalOperatorAccess().getGreaterEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='>='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getGreaterEqualEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getRelationalOperatorAccess().getGreaterEqualEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='=='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getEqualsEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getRelationalOperatorAccess().getEqualsEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='!='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getNotEqualsEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getRelationalOperatorAccess().getNotEqualsEnumLiteralDeclaration_5());
			}
		)
	)
;

RULE_LONG : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_BOOL : ('true'|'false'|'yes'|'no');

RULE_HEX : '0' ('x'|'X') ('0'..'9'|'a'..'f'|'A'..'F')+;

RULE_BINARY : '0' ('b'|'B') ('0'|'1')+;

RULE_DOUBLE : RULE_INT '.' RULE_INT (('e'|'E') ('-'|'+')? RULE_INT)? ('d'|'D')?;

RULE_FLOAT : RULE_INT '.' RULE_INT (('e'|'E') ('-'|'+')? RULE_INT)? ('f'|'F')?;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

fragment RULE_INT : ('0'..'9')+;

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
