/**
 * Copyright (c) 2019-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	itemis AG
 * 
 */
package com.yakindu.sct.model.stext.scoping

import com.yakindu.base.types.Type
import java.util.ArrayList
import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EcorePackage
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.AbstractScope

import static extension com.yakindu.base.types.TypesUtil.*

/**
 * Adds the container type of the context and all its inner types to the scope.
 * 
 * This allows type references to the container type and its inner types, also when these are protected and hence not exported to the outside world.
 */
class GlobalTypeScope extends AbstractScope {

	Resource context
	EClass type
		
	new(IScope outer, Resource context) {
		this(outer, context, EcorePackage.Literals.EOBJECT)
	}
	
	new(IScope outer, Resource context, EClass type) {
		super(outer, false)
		this.context = context
		this.type = type
	}
	
	override protected getAllLocalElements() {
		val fqResult = new ArrayList<Type>
		fqResult.addGlobalTypes()
		Scopes.scopedElementsFor(fqResult) + Scopes.scopedElementsFor(fqResult, [EObject e | e.toQualifiedName()]).filter[type.isSuperTypeOf(it.EClass)]
	}
	
	def void addGlobalTypes(ArrayList<Type> result) {
		result += context.allContents
			.filter(Type)
			.toList
	}

	
}
