/*
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
 
package com.yakindu.sct.model.stext.validation

import com.google.inject.Inject
import com.google.inject.name.Named
import com.yakindu.base.base.BasePackage
import com.yakindu.base.expressions.expressions.ExpressionsPackage
import com.yakindu.sct.domain.^extension.DomainRegistry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.resource.AbstractSCTResource
import com.yakindu.sct.model.stext.extensions.STextExtensions
import java.util.List
import java.util.Map
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EPackage
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.resource.XtextResource

class STextRootValidator extends AbstractSTextValidator {
	
	@Inject(optional=true)
	@Named(DomainRegistry.DOMAIN_ID)
	String domainID = BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral()
	@Inject
	protected extension STextExtensions utils

	override protected String getCurrentLanguage(Map<Object, Object> context, EObject eObject) {
		var Resource eResource = eObject.eResource()
		if (eResource instanceof XtextResource) {
			return super.getCurrentLanguage(context, eObject)
		} else if (eResource instanceof AbstractSCTResource) {
			return eResource.getLanguageName()
		}
		return ""
	}

	override protected List<EPackage> getEPackages() {
		var List<EPackage> result = super.getEPackages()
		result.add(ExpressionsPackage.eINSTANCE)
		return result
	}

	override protected boolean isResponsible(Map<Object, Object> context, EObject eObject) {
		var boolean isResponsible = super.isResponsible(context, eObject)
		if(!isResponsible) return false
		var Statechart statechart = utils.getStatechart(eObject)
		if ((statechart !== null) && !domainID.equals(statechart.getDomainID())) {
			return false
		}
		return true
	}
	
}