/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.validation

import com.yakindu.base.types.Trigger
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.stext.stext.DefaultTrigger
import org.eclipse.emf.common.util.EList
import org.eclipse.xtext.validation.Check
import org.eclipse.xtext.validation.CheckType

class StateValidator extends STextBaseValidator {
	
	public static final String DEFAULT_AND_ELSE_TRANSITION_ON_REGULAR_STATE = "'Default' and 'else' transitions should only be used for choices. Use 'always' or 'oncycle' instead.";
	
	@Check(CheckType.FAST)
	def void checkDefaultAndElseIsNotUsedOnRegularState(RegularState state) {
		var EList<Transition> outgoingTransitions = state.outgoingTransitions
		for (Transition transition : outgoingTransitions) {
			var Trigger trigger = transition.trigger
			if (trigger instanceof DefaultTrigger) {
				warning(DEFAULT_AND_ELSE_TRANSITION_ON_REGULAR_STATE, transition, null, -1)
			}
		}
	}
}