package com.yakindu.sct.generator.core.codemodel

/**
 * Copyright (c) 2021-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IEnumCode
import com.itemis.create.base.generator.core.concepts.Documentation
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.annotations.DeprecatedAnnotations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import org.eclipse.emf.ecore.EObject

/**
 * This extension defines a state machines state enumaration. 
 * 
 * @author axel terfloth - Initial contribution.
 */
@Singleton
class StateEnum {

	public static final String NO_STATE = "NO_STATE"
	public static final String STATE_ENUM_NAME = "State"

	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension INamingService
	@Inject protected extension SExecExtensions
	@Inject protected extension StatemachineClass
	@Inject protected extension Documentation

	@Inject protected extension GeneratorAssignment
	@Inject protected extension IEnumCode

	@Inject protected extension Statechart2TypeTransformation
	@Inject protected extension OriginTracing
	@Inject protected extension DeprecatedAnnotations

	def create e: createEnumerationType() defineStateEnum(Statechart sc) {

		sc.createTypeDescription
		val slangStateEnum = sc.stateEnumType

		e.documentation("Enumeration of all states.")
		e._public
		e.name = STATE_ENUM_NAME

		slangStateEnum.enumerator.filter[! isDeprecated].forEach [ en |
			e.enumerator += createEnumerator => [
				it.name = if(noStateName == en.name) NO_STATE else en.name
				it.traceOrigin(en)
			]
		]

		e.generateDeclarationWith[e.enumerationCode]
		sc.stateMachineClass.features += e
		e.traceOrigin(slangStateEnum)

	}

	def defineStateEnum(ExecutionFlow flow, ComplexType container) {
		flow.statechart.defineStateEnum
	}

	def stateEnum(ExecutionFlow it) {
		stateMachineClass.features.filter(EnumerationType).filter[name == STATE_ENUM_NAME].head
	}

	def stateEnum(Statechart it) {
		stateMachineClass.features.filter(EnumerationType).filter[name == STATE_ENUM_NAME].head
	}
	
	def stateEnum(ComplexType it) {
		stateMachineClass.features.filter(EnumerationType).filter[name == STATE_ENUM_NAME].head
	}

	def noStateEnumerator(Statechart it) {
		stateEnum.enumerator.findFirst[e|e.name == NO_STATE]
	}

	def noStateEnumerator(ExecutionFlow it) {
		statechart.noStateEnumerator
	}

	def enumerator(ExecutionState it) {
		enumerator(it.sourceElement as RegularState)
	}

	def enumerator(RegularState it) {
		statechart.stateEnum.enumerator.findFirst[e|(e.origin as EObject).origin === it]
	}

}
