package com.yakindu.sct.generator.core.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.generator.core.concepts.EventMembers
import com.yakindu.sct.generator.core.extensions.EventQueueExtension
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.concepts.RunCycleMethod
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil

class StatemachineEvents {
		
	@Inject protected extension TypeBuilder
	@Inject protected extension StatemachineClass
	@Inject protected extension SExecExtensions
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IVariableCode
	@Inject protected extension INamingService
	@Inject protected extension Documentation
	@Inject protected extension ExpressionBuilder
	@Inject protected extension ITypeValueProvider
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension EventQueue
	@Inject protected extension RunCycleMethod
	@Inject protected extension EventQueueExtension
	@Inject protected extension OriginTracing
	@Inject protected extension EventMembers
	
	def protected defineRaisedFlag(EventDefinition e) {
		val member =  _variable(e.eventRaisedFlag, _boolean ) => [
			traceOrigin(e)
			documentation('''Indicates event '«e.name»' of «e.scope.scopeDescription» is active.''')
			_private
			initialValue = _false
			generateDeclarationWith[ variableDeclarationCode ]			
		]		
		e.scope.scopeClass.features += member
		return member
	}
	
	def protected defineEventValueVariable(EventDefinition e) {
		val member =  _variable(e.eventValueVariable, EcoreUtil.copy(e.typeSpecifier)) => [
			initialValue = typeSpecifier.type.defaultValue._value
			documentation('''Value of event '«e.name»' of «e.scope.scopeDescription».''')
			_private
			
			generateDeclarationWith[ variableDeclarationCode ]			
		]		
		e.scope.scopeClass.features += member
		return member
	}
	
	def dispatch getEventValueVariableForEvent(Declaration e, ComplexType smClass){
		smClass.features.filter[name == e.origin.eventValueVariable || name == e.eventValueVariable].head
	}
	
	def dispatch getEventValueVariableForEvent(Object e, ComplexType smClass){}
	
	def protected defineInEventAccessors(EventDefinition e) {
		e.defineEventVariables
		//This is duplicate, as we define a separate raiser Op like this to substitue EventRaisingExpression in throughout transfromation
		e.defineRaiseMethod => [_public]		
	}
	
	def protected defineShadowEventAccessors(EventDefinition e) {
		e.defineEventVariables
		e.defineRaiseMethod => [_private]		
	}
	
	def protected defineEventVariables(EventDefinition e) {
		e.defineEventRaisedFlag => [generateDeclarationWith[variableDeclarationCode]]
		if (e.hasValue) e.defineEventValueMember => [generateDeclarationWith[variableDeclarationCode]]								
	}
	
	//TODO: This is duplicate for C++11, the one should be used defined in 'EventRaiser'
	def protected defineRaiseMethod(EventDefinition e) {
		val method = _op(e.asRaiser, _void) => [
			documentation('''Raises the in event '«e.name»' of «e.scope.scopeDescription».''')
			if (e.hasValue) {
				_param(e.asParameter, EcoreUtil.copy(e.typeSpecifier))
			}			
		]
		
		e.scope.scopeClass.features += method
		return method
	}
	
	def getStatemachineEvent(Event e, ComplexType smClass) {
		smClass.features.filter[name == e.eventRaisedFlag].head
	}
	
	def getStatemachineEvent(EventDefinition e) {
		e.scope.scopeClass.features.filter[name === e.name].head
	}
	
	def protected activateEventCode(EventDefinition e) '''
		«IF e.hasValue»
			«e.eventValueMemberType.name» = «e.asParameter»;
		«ENDIF»
		«e.eventRaisedFlagType.name» = true;
	'''
	//TODO: Should be obsolate
	def eventRaisedFlag(Event it) {
		 name.asIdentifier.raised
	}
	//TODO: Should be obsolate
	def dispatch eventValueVariable(Declaration it) {
		name.asIdentifier.value
	}
	
	def dispatch eventValueVariable(Object it) {}
	
	def dispatch eventValueVariable(Void it) {}
	
	def asRaiser(EventDefinition it) {
		'raise' + name.asIdentifier.toFirstUpper
	}
	
	def dispatch String asParameter(EventDefinition it){
		name.asParameter
	}
	
	def dispatch String asParameter(String it){
		asIdentifier + "_"
	}
	
	def valueParams(EventDefinition it) {
		if(hasValue) typeSpecifier.targetLanguageName + " " + asParameter
		else if(hasMetaValue) getMetaValue.targetLanguageName + " " + asParameter
		else ''
	}
	
	def getMetaValue(EventDefinition e) {
		e.metaFeatures.filter(Property).head.typeSpecifier
	}
	
	def dispatch localAccess(VariableDefinition it) '''«name.asEscapedIdentifier»'''

	def dispatch localAccess(Event it) '''«name.asIdentifier.raised»'''
	
	def dispatch localValueAccess(Event it) '''«name.asIdentifier.value»'''
	
	def dispatch localValueAccess(EObject it) ''''''
	
	//TODO: Should be obsolate
	def value(CharSequence it) { it + 'Value' }
	//TODO: Should be obsolate
	def raised(CharSequence it) { it + 'Raised' }
	
	def queueEventCode(Property queue, Declaration context, EventDefinition e,  String valueCode) ''''''
}