/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.Operation
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesUtil
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.concepts.TriggerWithoutEventMethod
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions
import com.yakindu.sct.model.sexec.naming.INamingService

class StatemachineFunctions {
		
	@Inject protected extension TypeBuilder
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension ExpressionBuilder
	@Inject protected extension StatemachineClass
	@Inject protected extension Documentation
	
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IMethodCode
	@Inject protected extension INamingService
	@Inject protected extension StateVectorExtensions
	@Inject protected extension StateEnum
	@Inject protected extension SExecExtensions
	@Inject protected extension TriggerWithoutEventMethod
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension TypesUtil
	
	def defineFunctions(ExecutionFlow flow) {
		
		val smClass = flow.stateMachineClass
		smClass.features += flow.defineIsActive
		smClass.features += flow.defineIsFinal
		smClass.features += flow.defineIsStateActive
		if(flow.hasTriggerWithoutEvents)
		smClass.features += flow.triggerWithoutEvents => [generateDefinitionWith[ methodDefinitionCode ]]
		
	}
	
	def isActiveName() {
		"isActive"	
	}
	
	def protected defineIsActive(ExecutionFlow flow){
		val method = _op(isActiveName, _boolean) => [
			documentation('''
			A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
			''')
			_public

			generateDefinitionWith['''
			«visibility.visibilityName» «it.type.targetLanguageName» «name»()
			{
				return «FOR i : 0 ..< flow.stateVector.size SEPARATOR '||'»«stateConfVector»[«i»] != «flow.enumAccess»«flow.noStateEnumerator.name»«ENDFOR»;
			}
			''']
			
		]

		return method
	}
	
	def isActive(ExecutionFlow it) {
		stateMachineClass.features.filter(Operation).filter[ name == isActiveName].head
	}
	
	
	
	def isFinalName() {
		"isFinal"	
	}
	
	def protected defineIsFinal(ExecutionFlow flow){
		val finalStateImpactVector = flow.finalStateImpactVector
		val method = _op(isFinalName, _boolean) => [
			documentation('''
			Checks whether all active states are final. If there are no active states then the state machine is considered being inactive.
			''')
			_public

			generateDefinitionWith['''
			«visibility.visibilityName» «it.type.targetLanguageName» «name»()
			{
				«IF finalStateImpactVector.isCompletelyCovered»
				return «FOR i : 0 ..<finalStateImpactVector.size SEPARATOR ' && '»(«FOR fs : finalStateImpactVector.get(i) SEPARATOR ' || '»«stateConfVector»[«i»] == «
											IF fs.stateVector.offset == i
												»«flow.enumAccess»«fs.enumerator.name»«
											ELSE
												»«flow.enumAccess»«flow.noStateEnumerator.name»«
											ENDIF»«
										ENDFOR»)«ENDFOR»;
				«ELSE»
				return false;
				«ENDIF»
			}
			''']
			
		]

		return method
	}
	
	def isFinal(ExecutionFlow it) {
		stateMachineClass.features.filter(Operation).filter[ name == isFinalName].head
	}
	
	
	
	def isStateActiveName() {
		"isStateActive"	
	}
	
	def protected defineIsStateActive(ExecutionFlow flow) {
		val method = _op(isStateActiveName, _boolean) => [
			documentation('''
			Returns true if the given state is currently active otherwise false.
			''')
			_public

			generateDefinitionWith['''
			«visibility.visibilityName» «it.type.targetLanguageName» «name»(«flow.stateEnum.name» state)
					{
						switch (state)
						{
							«FOR s : flow.states»
							case «flow.enumAccess»«s.enumerator.name» :
							{
								return («
								IF s.leaf
								»«stateConfVector»[«s.stateVectorDefine»] == «flow.enumAccess»«s.enumerator.name»«
								ELSE
								»«stateConfVector»[«s.stateVectorDefine»] >= «flow.enumAccess»«s.enumerator.name» && «stateConfVector»[«s.stateVectorDefine»] <= «flow.enumAccess»«s.subStates.lastOrNull.enumerator.name»«
								ENDIF»);
								«IF needsBreak»break;«ENDIF»
							}
							«ENDFOR»
							default:
							{
								/* State is not active*/
								return false;
								«IF needsBreak»break;«ENDIF»
							}
						}
					}
			''']
			
		]

		return method
	}
	
	def isStateActive(ExecutionFlow it) {
		stateMachineClass.features.filter(Operation).filter[ name == isStateActiveName].head
	}
	
	
	
	def stateConfVector()'''
	stateConfVector'''
	
	def enumAccess(ExecutionFlow it)'''
	'''
	
	def needsBreak(){
		true
	}
	
	def stateVectorDefine(ExecutionState it) {
		'''scvi_«shortName»'''
	}
	
}