/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Thomas Kutz - itemis AG
 * 
 */
package com.yakindu.sct.generator.core.execution

import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess
import org.eclipse.xtend.lib.annotations.Delegate

/**
 * Wrapper for file system access to exchange contents with text about missing license
 * 
 * @author Thomas Kutz - Initial contribution and API
 */
class NoLicenseFSAWrapper implements ISCTFileSystemAccess {

	@Delegate
	val ISCTFileSystemAccess fsa

	new(ISCTFileSystemAccess fsa) {
		this.fsa = fsa
	}

	def protected getNoValidLicenseText() '''
		/*
		 *  No valid license found!
		 *  
		 *  Please check your license settings on the itemis CREATE Licenses preference page.
		 *  For more information on our licensing scheme please visit our website: http://statecharts.org/licences?source=product
		 * 
		 */
	'''

	override deleteFile(String fileName) {
		fsa.deleteFile(fileName)
	}

	override generateFile(String fileName, CharSequence contents) {
		fsa.generateFile(fileName, noValidLicenseText)

	}

	override generateFile(String fileName, String outputConfigurationName, CharSequence contents) {
		fsa.generateFile(fileName, outputConfigurationName, noValidLicenseText)
	}

}
