/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.extensions

import com.google.inject.Inject
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

class GeneratorPredicate {

	@Inject protected extension StatechartAnnotations
	@Inject protected GeneratorEntry entry
	@Inject protected extension ICoreLibraryHelper

	def boolean isEventDriven() {
		entry.statechart.eventDriven
	}

	def useOutEventObservables() {
		getOutEventObservablesUsed(entry)
	}

	def useOutEventGetters() {
		getOutEventGettersUsed(entry)
	}

	def needsObservable(Event it) {
		useOutEventObservables && direction === Direction.OUT
	}

	def dispatch Statechart getStatechart(ExecutionFlow it) {
		it.sourceElement as Statechart
	}

	def dispatch Statechart getStatechart(GeneratorEntry it) {
		it.elementRef as Statechart
	}
}
