/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.core.library

import com.google.inject.Inject
import com.google.inject.Provider
import com.google.inject.name.Named
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.sgen.FeatureTypeLibrary
import com.yakindu.sct.model.sgen.SGenFactory
import org.eclipse.emf.ecore.resource.impl.ResourceImpl

abstract class AbstractFeatureTypeLibraryProvider implements IFeatureTypeLibraryProvider {
	public static final String FEATURE_TYPE_LIBRARY_PROVIDER_TYPESYSTEM = "FeatureTypeLibraryProviderTypesystem";
	
	@Inject
	@Named(FEATURE_TYPE_LIBRARY_PROVIDER_TYPESYSTEM)
	protected extension var ITypeSystem typeSystem
	@Inject protected extension var SGenFactory sgenFactory
	
	val resource = new ResourceImpl()
	var FeatureTypeLibrary lib		
	
	abstract protected def FeatureTypeLibrary provide()
	
	private def updateDocumentationLibraries(FeatureTypeLibrary library) {
		val name = library.name 
		for (tpe : library.types) {
			if (tpe.documentationLibraryName === null) {
				tpe.documentationLibraryName = name
			}
			for (param : tpe.parameters) {
				if (param.documentationLibraryName === null) {
					param.documentationLibraryName = name
				}
			}
		}
	}
	
	protected final def create(Provider<FeatureTypeLibrary> provider) {
		val result = provider.get()
		updateDocumentationLibraries(result)
		result
	}
	
	final def FeatureTypeLibrary create() {
		create([provide])	
	} 
	
	override get() {
		if (lib === null) {
			lib = create()
			resource.contents += lib
		}
		lib
	}
}