/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sct.generator.core.templates

import com.google.inject.Inject
import com.itemis.create.base.generator.core.codepattern.BaseExpressionCode
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.types.Operation
import com.yakindu.sct.generator.core.submodules.lifecycle.NamedConceptSequenceCode
import com.yakindu.sct.model.sexec.concepts.StateMachineBehaviorConcept
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

/**
 * 
 * @author Rene Beckmann - Initial contribution and API
 */
class ExpressionsGenerator extends BaseExpressionCode {
	
	@Inject protected extension StateMachineBehaviorConcept
	@Inject protected extension SExecExtensions
	@Inject protected extension NamedConceptSequenceCode
	
	def dispatch CharSequence code(ElementReferenceExpression it, Operation target){
		if (target.isStateMachineConcept) 
			it.flow.stateMachineConceptCode(target)
		else
			throw new IllegalStateException("No dispatch function for " + getClass().name)
	} 
	
}
