/**
 * Copyright (c) 2023-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.templates

import com.google.inject.Inject
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Expression
import com.yakindu.sct.generator.core.submodules.lifecycle.TraceCode
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.LocalVariableDefinition
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.VariableDefinition
import org.eclipse.emf.ecore.EObject

/**
 * @author Axel Terfloth
 */
class TraceCodeGenerator implements com.yakindu.sct.generator.core.submodules.lifecycle.TraceCode {
	
	@Inject extension protected SExecExtensions
	@Inject extension protected StatechartUtil
	@Inject protected GeneratorEntry entry
	
	def dispatch CharSequence traceCode(Object it) ''''''


	override traceEnterCode(ExecutionFlow it) ''''''
	
	
	override traceExitCode(ExecutionFlow it) ''''''
	
	
	/**************************************************************************
	 * common trace code generator implementation 
	 */
	 
	def protected dispatch CharSequence notifyTrace(Object it) ''''''
	
	def protected dispatch CharSequence notifyTrace(Expression it) {
		val traceAssignees = (it.eAllContents.toList => [ l | l.add(0, it)])
							.map[ assignee ]
							.filterNull
							.filter[ v | ! v.isVarFromOtherStatechart ]
							.filter[ v | ! (v.definition.eContainer instanceof LocalVariableDefinition)]
							.filter[ v | v.definition instanceof VariableDefinition ]
							.toSet
							
		val traceVars = traceAssignees.map( a | a.definition ).toSet
		val traceUniqueAssignees = traceAssignees.filter[ a | traceVars.remove(a.definition)]
							
		'''
			«FOR v : traceUniqueAssignees»
				«v.definition.notifyTrace()»;
			«ENDFOR»
		'''
	}
	
	def protected dispatch Expression assignee(EObject it) { null }
	def protected dispatch Expression assignee(PostFixUnaryExpression it) { operand }


	def isVarFromOtherStatechart(Expression it) {
		return (it instanceof FeatureCall) 
			&& ((it as FeatureCall).feature.eContainer instanceof ComplexType) 
			&& (it as FeatureCall ).feature.eContainer.isMultiSM
	}
	
	def tracefeatureEnumMemberName(NamedElement it) {
		#[scope.defaultInterfaceName, name].filter[!nullOrEmpty].join("_").toUpperCase
	}	
	
}