/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter

import com.google.inject.Inject
import java.util.List
import org.eclipse.emf.ecore.EObject
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.Argument
import com.yakindu.base.types.Operation
import com.yakindu.base.types.util.ArgumentSorter
import com.yakindu.sct.model.sruntime.ExecutionContext

/**
 * @author andreas muelder - Initial contribution and API 
 * 
 */
abstract class AbstractOperationExecutor implements IOperationExecutor {

	@Inject extension protected IExpressionInterpreter interpreter
	
	@Inject extension ExpressionExtensions

	def getOperation(ArgumentExpression it) {
		it.featureOrReference as Operation
	}

	def dispatch EObject getOwner(FeatureCall it) {
		val owner = it.owner
		if (owner instanceof ArgumentExpression) {
			return owner.featureOrReference
		}
	}

	def dispatch EObject getOwner(ArgumentExpression it) {}

	def provideArguments(List<Object> argumentValues, List<Argument> arguments, ExecutionContext context, Operation operation) {
		if ( argumentValues === null ) {
			val orderedExpressions = ArgumentSorter.getOrderedExpressions(arguments, operation)
			orderedExpressions.map(it|evaluate(context)).toArray			
		} else {
			argumentValues.toArray
		}
	}

}
