/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.base

import java.util.ArrayList
import java.util.List
import org.eclipse.xtend.lib.annotations.Data

/**
 * Defines a set of methods which can be used by concrete Execution implementations. 
 * 
 * @author axel terfloth
 */
abstract class BaseExecution implements IInterpreter.Execution  {

	protected extension IInterpreter.Context context
		
	override setExecutionContext(IInterpreter.Context context) {
		this.context = context
	}
	
	def getExecutionContext() {
		this.context
	}
	
	protected def void _exec(Object o) {
		o.provideExecution	
	}

	def void _value() {
		_return("value", [
			popValue.get
		])
	}

	def void _return(()=>Object f) {
		_return("return", f)
	}
	
	def void _execute(Runnable f) {
		_execute("execute", f)
	}
	
	def void _executeOperation(Object owner, String name, List<String> parameters, Runnable body) {
		_executeOperation ('''«name»''', owner,  name, parameters, body)
	}
	
	def void _executeOperation(String description, Object owner, String name, List<String> parameters, Runnable body) {
		_execute (description, [ 
			val paramValues = new ArrayList<Object>
			parameters.forEach[paramValues.add(popValue)]
			enterCall(description)
			if(owner !== null) defineVariable(InstanceSemantics.SELF_NAME, owner)
			parameters.reverseView.forEach[ p, i | 
				defineVariable(p, paramValues.get(i))
			]
			body.run
		])
	}
	
	def void _delegate(Object program) {
		program._requestExecution(this)
	}
	
	@Data static class Invokation {
		
		protected Object caller
		protected Object receiver
		protected Object operation
		
	}
}