/**
 * Copyright (c) 2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.types

import com.google.inject.Inject
import com.yakindu.base.types.Package
import com.yakindu.base.types.scoping.IPackageImport2URIMapper
import com.yakindu.base.types.scoping.IPackageImport2URIMapper.PackageImport
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.resource.ResourceSet

/**
 * @author Axel Terfloth
 */
class PackageHelper {
	
	@Inject protected extension IPackageImport2URIMapper includeMapper;

	def List<Package> importedPackages(EObject it) {
		provideImportedPackages
	}
	
	
	def protected dispatch List<Package> provideImportedPackages(EObject it) {
		#[]
	}
	
	
	def protected dispatch provideImportedPackages(Package it) {
		val List<Package> packages = newArrayList
		val set = it.eResource.resourceSet
		packageImports
			.forEach [ import |
				val resource = set.getResource(import.fileURI, true)
				val pkg = resource.contents.filter(Package).head
				if (pkg !== null) {
					packages += pkg
				}
		]
		return packages
	}
	
	def protected importedPackages(Iterable<PackageImport> pkgImports, ResourceSet set) {
				
		val List<Package> packages = newArrayList
		pkgImports
			.forEach [ import |
				val resource = set.getResource(import.fileURI, true)
				val pkg = resource.contents.filter(Package).head
				if (pkg !== null) {
					packages += pkg
				}
		]
		return packages
	}
	
		
	def protected packageImports(Package pkg) {

		return pkg
				.imports
				.map[pkg.eResource.findPackageImport(it)]
				.filter[isPresent]
				.map[get]
	}


}
