/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java

import com.google.inject.Inject
import com.yakindu.sct.generator.core.templates.SexecGenerator
import com.yakindu.sct.model.sexec.Call
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.CheckRef
import com.yakindu.sct.model.sexec.DoWhile
import com.yakindu.sct.model.sexec.EnterState
import com.yakindu.sct.model.sexec.ExitState
import com.yakindu.sct.model.sexec.HistoryEntry
import com.yakindu.sct.model.sexec.If
import com.yakindu.sct.model.sexec.SaveHistory
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sexec.StateSwitch
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.UnscheduleTimeEvent
import com.yakindu.sct.model.sexec.concepts.MicroStep
import com.yakindu.sct.model.sexec.concepts.SuperStep
import java.util.List
import com.yakindu.sct.model.sgraph.util.SgraphExtensions

class FlowCode extends SexecGenerator {
	
	@Inject extension Naming
	@Inject extension SuperStep
	@Inject extension MicroStep
	@Inject extension SgraphExtensions
			
	var List<TimeEvent> timeEvents;
		
		
	def dispatch CharSequence code(StateSwitch it) '''
		«IF historyRegion !== null»
			switch (historyVector[«historyRegion.historyVector.offset»]) {
		«ELSE»
			switch (stateVector[«stateConfigurationIdx»]) {
		«ENDIF»
		«FOR stateCase : cases»
			case «stateCase.state.stateName»:
				«IF stateCase.step !== null»«stateCase.step.code»«ENDIF»
				break;
		«ENDFOR»
		default:
			break;
		}
	'''
	
	def dispatch CharSequence code(ScheduleTimeEvent it) '''
		«stepComment»
		«timerServiceInstance».setTimer(this, «getTimeEvents.indexOf(timeEvent)», «timeValue.code», «IF timeEvent.periodic»true«ELSE»false«ENDIF»);
		«traceCode»
	'''
	
	def dispatch CharSequence code(UnscheduleTimeEvent it) '''
		«stepComment»
		«timerServiceInstance».unsetTimer(this, «getTimeEvents.indexOf(timeEvent)»);
		«traceCode»
	'''
	
	def dispatch CharSequence code(Call it) '''«step.functionName()»();'''
	
	
	def dispatch CharSequence code(Check it) {
		if (condition !== null) 
			condition.code
		else 
			"true"
	}

	def dispatch CharSequence code(CheckRef it) '''«IF check !== null»«comment»«check.functionName()»()«ELSE»true«ENDIF»'''
	
	
	def dispatch CharSequence code(If it) '''
		«stepComment»
		if («check.code.toString.trim») {
			«thenStep.code»
		}«IF elseStep !== null» else {
			«elseStep.code»
		}
		«ENDIF»
	'''
	
	def dispatch CharSequence code(DoWhile it) '''
		«stepComment»
		do { 
			«body.code»
		} while («check.code»);
	'''

	def dispatch CharSequence code(EnterState it) {
		val firstPos = state.statevectorFirstPosition
		val lastPos = state.statevectorLastPosition
		
		'''
			«stepComment»
			«FOR i: firstPos .. lastPos»
				stateVector[«i»] = State.«state.stateName»;
			«ENDFOR»
			«IF flow.needsStateVectorPosition»
				«MicroStep.STATE_VECTOR_POSITION» = «firstPos»;
			«ENDIF»
			«flow._stateChanged.code»
		'''
	}
	
	def dispatch CharSequence code(ExitState it) {
		val parentState = it.state.sourceElement.parentState
		val stateName = if ( parentState !== null ) parentState.stateName else nullStateName
		val firstPos = state.statevectorFirstPosition
		val lastPos = state.statevectorLastPosition
		
		'''
			«stepComment»
			«FOR i: firstPos .. lastPos»
				stateVector[«i»] = State.«stateName»;
			«ENDFOR»
			«IF flow.needsStateVectorPosition»
				«MicroStep.STATE_VECTOR_POSITION» = «lastPos»;
			«ENDIF»
		'''
	}
	
	def dispatch CharSequence code(HistoryEntry it) '''
		«stepComment»
		if (historyVector[«region.historyVector.offset»] != State.«nullStateName()») {
			«historyStep.code»
		} «IF initialStep !== null»else {
			«initialStep.code»
		}«ENDIF»
	'''
	
	def dispatch CharSequence code(SaveHistory it) '''
		«stepComment»
		historyVector[«region.historyVector.offset»] = stateVector[«region.stateVector.offset»];
	'''
	
	def private getTimeEvents(Step it) {
		if (timeEvents === null) {
			timeEvents = flow.timeEvents
		}
		return timeEvents
	}
	

}