/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.AssignmentOperator
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.FloatLiteral
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.IntLiteral
import com.yakindu.base.expressions.expressions.LogicalRelationExpression
import com.yakindu.base.expressions.expressions.MetaCall
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.expressions.expressions.RelationalOperator
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Event
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Property
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.templates.ExpressionsGenerator
import com.yakindu.sct.model.sexec.LocalVariableDefinition
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.concepts.BufferEvent
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sct.model.stext.stext.StatechartScope
import java.util.List
import org.eclipse.emf.ecore.EObject

class JavaExpressionsGenerator extends ExpressionsGenerator {

	@Inject protected extension Naming
	@Inject protected extension JavaNamingService
	@Inject protected extension SExecExtensions
	@Inject protected extension ITypeSystem
	@Inject protected extension ITypeSystemInferrer
	@Inject protected extension OriginTracing
	@Inject protected extension StatechartUtil
	@Inject protected extension BufferEvent
	@Inject protected extension EventBuffer
	@Inject protected extension ExpressionExtensions

	static val String CONSTRUCTOR = "new"

	var List<TimeEvent> timeEvents;

	def private getTimeEvents(TimeEvent it) {
		if (timeEvents === null) {
			timeEvents = flow.timeEvents
		}
		return timeEvents
	}

	def dispatch String code(OperationDefinition it) {
		eContainerOfType(StatechartScope).operationCallbackInstance + "." + name.asEscapedIdentifier
	}
	
	override dispatch CharSequence code(InitializationExpression it) {
		
		val originType = it.infer.type

		// TODO: we always have to use a normalized / ordered argument list. we should not care about this aspect here in the 2text transformation.
		//Either names or order is correct
		if (originType !== null && originType instanceof ComplexType) {
			if(arguments.exists[a | a.parameter !== null && a.parameter.name !== null])
			'''«CONSTRUCTOR» «originType.name»(«FOR p : originType.features.filter(Property) SEPARATOR ','»«arguments.filter(pr | pr.parameter.name.equals(p.name)).head.value.code»«ENDFOR»);'''
			else
			'''«CONSTRUCTOR» «originType.name»(«FOR a : arguments SEPARATOR ','»«a.value.code»«ENDFOR»);'''

		}
		else {
			'''/* can not determine class name for «it» */'''
		}
	}
	
	/* Assignment */
	override dispatch String code(AssignmentExpression it) {
		val property = varRef.definition
		if (property instanceof Property) {
			val container = property.eContainer
			if (container instanceof LocalVariableDefinition) {
				return '''«property.getContext»«property.name» = «assignCmdArgument(property)»'''
			}
			if (container instanceof ComplexType) {
				if (container.isMultiSM) {
					return '''«varRef.getContext»«property.setter»(«assignCmdArgument(property)»)'''
				}
				return '''«varRef.getContext»«property.name» = «assignCmdArgument(property)»'''
			}
			if (eContainer instanceof Expression) {
				return '''«property.getContext»«property.assign»(«assignCmdArgument(property)»)'''
			}
			return '''«varRef.getContext»«property.setter»(«assignCmdArgument(property)»)'''
		}
	}

	def protected assignCmdArgument(AssignmentExpression it, Property property) {
		var cmd = ""
		if (!AssignmentOperator.ASSIGN.equals(operator)) {
			cmd = property.getContext + property.getter + " " + operator.literal.replaceFirst("=", "") + " "

			if (expression instanceof PrimitiveValueExpression || expression instanceof ElementReferenceExpression ||
				expression instanceof AssignmentExpression) {
				cmd += expression.code
			} else {
				cmd += "(" + expression.code + ")"
			}

		} else {
			cmd = expression.code.toString
		}
		return cmd
	}

	def dispatch String code(LogicalRelationExpression expression) {
		if (expression.leftOperand.infer.type.isString) {
			expression.logicalString
		} else
			expression.leftOperand.code + expression.operator.literal + expression.rightOperand.code;
	}

	def protected String logicalString(LogicalRelationExpression expression) {
		if (expression.operator == RelationalOperator::EQUALS) {
			"(" + expression.leftOperand.code + "== null?" + expression.rightOperand.code + " ==null :" +
				expression.leftOperand.code + ".equals(" + expression.rightOperand.code + "))"
		} else if (expression.operator == RelationalOperator::NOT_EQUALS) {
			"(" + expression.leftOperand.code + "== null?" + expression.rightOperand.code + " !=null : !" +
				expression.leftOperand.code + ".equals(" + expression.rightOperand.code + "))"
		}
	}

	def dispatch String code(ActiveStateReferenceExpression it) {
		"isStateActive(State." + value.stateName + ")";
	}

	def dispatch String code(EventRaisingExpression it) {
		if (value !== null) {
			event.getContext + "raise" + event.definition.name.toFirstUpper + "(" + value.code + ")"
		} else {
			event.getContext + "raise" + event.definition.name.toFirstUpper + "()"
		}
	}

	def dispatch String code(EventValueReferenceExpression it) {
		value.getContext + value.definition.event.getter
	}

	override dispatch String code(ElementReferenceExpression it) {
		val ref = it.reference
		switch ref {
			Parameter:
				return ref.name
			ComplexType:
				return ref.name
			Declaration:
				return codeDeclaration(ref, it).toString
		}
	}

	def dispatch String code(MetaCall it) {
		feature.metaCode(owner)
	}

	def dispatch String metaCode(EObject it, Expression exp) '''/* cant generate meta code for «it» of «exp» */'''

	def dispatch String metaCode(Property it,
		ArgumentExpression exp) '''«codeDeclaration(it, exp)»«identifier.toString.toFirstUpper»'''

	override dispatch String code(FeatureCall it) {
		(it.feature as Declaration).codeDeclaration(it).toString
	}

	def protected codeDeclaration(Declaration it, ArgumentExpression exp) {
		switch it {
			Operation:
				if (isStateMachineConcept) {
					return flow.stateMachineConceptCode(it).toString
				} else
					return operationCall(it, exp)
			Event case exp.isComplexTypeContained && !isBufferEvent:
				return exp.getContext + "isRaised" + name.toFirstUpper + "()"
			Enumerator case it.eContainer.isOriginStateEnum:
				return stateEnumAccess
			Declaration case exp.isComplexTypeContained:
				return exp.getContext + exp.definition.code
			Property case exp.isAssignmentContained:
				return getStaticContext + identifier
			Property case exp.isPropertyContained:
				return getStaticContext + identifier
			Property case exp.isPostFixContained:
				return getStaticContext + identifier
			Declaration:
				return exp.definition.code
		}
	}

	def protected stateEnumAccess(Enumerator stateEnum) {
		val statechart = stateEnum.eContainer.getOriginStatechart
		val state = stateEnum.originState

		'''«statechart.statemachineClassName».State.«IF state !== null»«state.stateName»«ELSE»«nullStateName»«ENDIF»'''
	}

	def dispatch protected String operationCall(Method it, ArgumentExpression exp) {
		'''«code»(«exp.argCode»)'''
	}

	def dispatch protected String operationCall(Operation it, ArgumentExpression exp) {
		if (isConstructor)
			ctorCall(exp)
		else
			'''«exp.getContext»«code»(«exp.argCode»)'''
	}

	def dispatch String code(Declaration it) {
		getContext + identifier
	}

	def dispatch String code(Property it) {
		
		if (type !== null && type.isEventBuffer) {
			return name
		}
		if (eContainer instanceof ComplexType) {
			if (isInterfaceProperty) {
				return interfacePropertyScope.interfaceGetterName
			}
			return getter
		}
		if (eContainer instanceof LocalVariableDefinition) {
			return name
		}
		getContext + getter
	}

	def protected getInterfacePropertyScope(Property it) {
		type.originTraces.filter(InterfaceScope).head
	}

	def protected isInterfaceProperty(Property it) {
		getInterfacePropertyScope !== null
	}

	def dispatch String code(TimeEvent it) {
		"timeEvents[" + getTimeEvents.indexOf(it) + "]"
	}

	def dispatch String getContext(FeatureCall it) {
		val owner = it.owner
		if (owner instanceof ElementReferenceExpression) {
			if (owner.reference instanceof InterfaceScope) {
				// interface context
				return it.definition.getContext
			}
		}
		return it.owner.code + "."
	}

	def dispatch String getContext(ElementReferenceExpression it) {
		return it.definition.getContext
	}

	def dispatch String getStaticContext(Property it) {
		if (it.const) {
			if (isInNamedInterface) {
				return interfaceScope.interfaceTypeName + "."
			} else {
				return ""
			}
		}
		return getContext
	}

	def dispatch String getContext(Declaration it) {
		if (isInNamedInterface)
			interfaceScope.interfaceVariableName + "."
		else
			""
	}

	def dispatch String getContext(EObject it) {
		return "//ERROR: No context for " + it
	}

	def dispatch String getStaticContext(EObject it) {
		return "//ERROR: No context for " + it
	}

	def protected boolean isAssignmentContained(Expression it) {
		eContainerOfType(AssignmentExpression) !== null
	}

	def protected boolean isPropertyContained(Expression it) {
		eContainerOfType(Property) !== null
	}

	def protected dispatch boolean isComplexTypeContained(FeatureCall it) {
		definition.eContainer instanceof ComplexType
	}

	def protected dispatch boolean isComplexTypeContained(ElementReferenceExpression it) {
		false
	}

	def protected boolean isPostFixContained(Expression it) {
		eContainerOfType(PostFixUnaryExpression) !== null
	}

	override dispatch CharSequence code(FloatLiteral it) '''«value.toString»f'''

	override dispatch CharSequence code(IntLiteral it) '''«value.toString»l'''
	
	def protected isConstructor(Operation it) {
		it.name == CONSTRUCTOR && static
	}
	
	def protected String ctorCall(Operation it, ArgumentExpression exp) {
		'''«CONSTRUCTOR» «getContext + it.type.name»«IF !it.typeParameters.isEmpty»<>«ENDIF»(«FOR arg : exp.expressions SEPARATOR ", "»«arg.code»«ENDFOR»)'''
	}

}
