/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java

import com.google.common.collect.Sets
import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Package
import com.yakindu.base.types.scoping.IPackageImport2URIMapper
import com.yakindu.base.types.scoping.IPackageImport2URIMapper.PackageImport
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.ImportScope
import com.yakindu.sct.runtime.URIContentTypeHelper
import org.eclipse.emf.ecore.resource.Resource

class JavaStatechartIncludeProvider extends JavaIncludeProvider {

	@Inject protected IPackageImport2URIMapper includeMapper;

	@Inject extension StatechartUtil
	@Inject extension Naming
	@Inject extension GenmodelEntries
	@Inject extension StringHelper

	override Iterable<String> getImports(ExecutionFlow it, GeneratorEntry entry) {
		val imports = Sets.newHashSet
		for (PackageImport p : statechartImports) {
			val typesRes = (sourceElement as Statechart).eResource.resourceSet.getResource(p.uri, true);
			val submachineChart = typesRes.subchart
			val submachineClass = submachineChart.statemachineClassName
			if (!entry.getBasePackage(submachineChart).nullOrEmpty) {
				imports.add(entry.getBasePackage(submachineChart).dot(submachineClass))
			}
		}
		return imports
	}
	
	protected def getSubchart(Resource typesRes) {
		typesRes.contents.filter(Package).head.member.filter(ComplexType).filter[!(it instanceof EnumerationType)].map[getOriginStatechart].filterNull.head
	}

	protected def getStatechartImports(ExecutionFlow flow) {
		val statechart = flow.sourceElement as Statechart
		val statechartImports = statechart.scopes.filter(ImportScope).map[imports].flatten
		return statechartImports.map [
			includeMapper.findPackageImport(statechart.eResource, it)
		].filter[isPresent].map[get].filter[URIContentTypeHelper.isStatechart(fileURI)]
	}
}
