/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java

import com.google.inject.Inject
import com.yakindu.base.base.NamedElement
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Event
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.concepts.ShadowMemberScope
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.naming.StextNameProvider
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import org.eclipse.emf.ecore.EObject

import static extension org.eclipse.xtext.EcoreUtil2.*

class Naming {

	@Inject extension JavaNamingService
	@Inject extension OriginTracing
	@Inject extension ShadowMemberScope
	@Inject extension GenmodelEntries
	@Inject extension StextNameProvider
	@Inject extension SExecExtensions

	@Inject GeneratorEntry entry
	
	def internalStatemachineInterfaceName(ComplexType it){
		"I" +
		if(!superTypes.nullOrEmpty) it.toString.replace("Statemachine","")
		else it.toString
	}
	
	def iStatemachine() {
		"IStatemachine"
	}
		
	def iCycleBased() {
		"ICycleBased"
	}
	
	def iEventDriven() {
		"IEventDriven"
	}
	
	def iTimed() {
		"ITimed"
	}

	def iTimerService() {
		"ITimerService"
	}

	def timerServiceClass() {
		"TimerService"
	}
	
	def timerServiceInstance() {
		"timerService"
	}

	def timeEventClass() {
		"TimeEvent"
	}

	def runtimeServiceClass() {
		"RuntimeService"
	}
	
	def java(String it) {
		it + ".java"
	}

	def dispatch operationCallbackClass(InternalScope it) {
		"InternalOperationCallback"
	}
	def dispatch operationCallbackClass(InterfaceScope it) {
		"OperationCallback"
	}
		
	def dispatch operationCallbackInstance(InternalScope it) {
		"internalOperationCallback"
	}
	def dispatch operationCallbackInstance(InterfaceScope it) {
		"operationCallback"
	}
	
	def tracingListener() {
		"ITracingListener"
	}
	
	def traceEventClass() {
		"TraceEvent"
	}
	
	def traceEventTypeEnum() {
		"TraceEventType"
	}
	
	def traceAccessorFunctionID() {
		"traceObserver"
	}
	
	def traceSingleInstance() {
		"ifaceTraceObserver"
	}
	
	def traceInstances() {
		"ifaceTraceObservers"
	}
	
	def stateEnteredTraceFunctionID() {
		"onStateEntered"
	}
	
	def stateExitedTraceFunctionID() {
		"onStateExited"
	}
	
	def parentStatemachineInstance() {
		"parent"
	}

	def statemachineName(String name) {
		var String newName = name.replace(" ", "")
		if (name.isKeyword)
			newName + "SM"
		else
			newName
	}

	def statemachineClassName(NamedElement it) {
		entry.typeName ?: name.statemachineName.toFirstUpper
	}

	def dispatch identifier(Property it) { escaped.asIdentifier }
	def dispatch identifier(Event it) { escaped.asIdentifier }
	def dispatch identifier(Method it) { shortName }
	def dispatch identifier(Operation it) { name }
	def dispatch identifier(Enumerator it) { name }
	def dispatch identifier(Declaration it){ shortName }

	def valueProperty(Event it) {
		name.asIdentifier + "Value"
	}

	def dispatch String stateName(RegularState state) {
		val statechart = state.getContainerOfType(Statechart)
		val statechartFqn = statechart.fullyQualifiedName
		val stateFqn = state.fullyQualifiedName
		
		val trimmedFqn = stateFqn.skipFirst(statechartFqn.segmentCount)
		return trimmedFqn.segments.join("_").toUpperCase
	}

	def dispatch String stateName(ExecutionState it) {
		val state = sourceElement as RegularState
		state.stateName
	}
	
	def nullStateName() {
		"$NULLSTATE$"
	}

	def asName(String it) {
		asIdentifier.toFirstUpper
	}

	def asEscapedName(String it) {
		asEscapedIdentifier.toFirstUpper
	}

	def private escaped(Property it) {
		var varName = name
		if (isKeyword) {
			varName += "Variable"
		}
		return varName
	}

	def private escaped(Event it) {
		var varName = name
		if (isKeyword) {
			varName += "Event"
		}
		return varName
	}

	def String getter(Event it) {
		"get" + name.asName + "Value()"
	}

	def String getter(Property it) {
		methodName("get", "()")
	}

	def String setter(Property it) {
		methodName("set", "")
	}
	
	def String assign(Property it) {
		methodName("assign", "")
	}
	
	def private methodName(Property it, String prefix, String suffix) {
		var methodName = prefix + name.asName

		if (isStatemachineMethod(methodName) || isDerivedIdentifier(name)) {
			methodName = prefix + escaped.asName
		}

		return methodName + suffix
	}

	def functionName(Step it) { shortName }
	
	def eventBufferTypeName(Type it) {
		val typeOrigin = it.originTraces.filter(EObject).head
		typeOrigin.eventBufferPrefix + "EvBuf"
	}
	
	protected def dispatch eventBufferPrefix(EObject it) {
		"TimeEvents"
	}

	protected def dispatch eventBufferPrefix(InterfaceScope it) {
		interfaceTypeName ?: ""
	}

	protected def dispatch eventBufferPrefix(InternalScope it) {
		if (isShadowMemberScope) "Shadow" else "Internal"
	}

	protected def dispatch eventBufferPrefix(ExecutionFlow it) {
		statemachineClassName
	}
	
	def interfaceTypeName(InterfaceScope it) {
		name.toFirstUpper
	}
	
	def interfaceGetterName(InterfaceScope it) {
		name.asEscapedIdentifier + "()"
	}
	
	def interfaceVariableName(InterfaceScope it) {
		interfaceTypeName.asEscapedIdentifier
	}
	
}
