/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class ITracingListener {
	
	@Inject extension Naming
	@Inject extension GenmodelEntries
	@Inject extension ICoreLibraryHelper
	@Inject extension OutputConfigProvider
	@Inject extension StringHelper

	def generateTracingListener(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val fileName = entry.libraryPackage.toPath + '/' + tracingListener.java
		fsa.generateFile(fileName, entry.libraryOutputConfig, content(entry))
	}
	
	def private content(GeneratorEntry it) {
		'''
			«licenseText»
			«IF !libraryPackage.isNullOrEmpty»package «libraryPackage»;«ENDIF»
			
			/**
			 * Tracing interface for state machines.
			 * Must be implemented if tracing feature is used.
			 * Multiple listeners can be added to and removed from the state machine.
			 */
			public interface «tracingListener»<T> {
				
				/**
				 * «stateEnteredTraceFunctionID.toFirstUpper» will be called if any state has been entered.
				 */
				void «stateEnteredTraceFunctionID»(T state);
				
				/**
				* «stateExitedTraceFunctionID.toFirstUpper» will be called if any state has been exited.
				*/
				void «stateExitedTraceFunctionID»(T state);
			}
		'''
	}
}
