/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.Expression
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.java.GeneratorPredicate
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.JavaExpressionsGenerator
import com.yakindu.sct.generator.java.JavaIncludeProvider
import com.yakindu.sct.generator.java.JavaNamingService
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.features.OutEventObservables
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import java.util.Set
import org.eclipse.emf.ecore.EObject

@Singleton
class EventCode implements com.yakindu.sct.generator.core.submodules.lifecycle.EventCode {
	
	@Inject protected Set<JavaIncludeProvider> includeProviders
	@Inject protected extension Naming
	@Inject protected extension JavaNamingService
	@Inject protected extension GenmodelEntries
	@Inject protected extension SExecExtensions
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension ITypeSystem
	@Inject protected extension Synchronized
	@Inject protected extension GeneratorPredicate
	@Inject protected extension OutEventObservables
	@Inject protected extension FieldDeclarationGenerator
	@Inject protected extension JavaExpressionsGenerator
	@Inject protected extension EventProcessing
	@Inject protected extension ExpressionBuilder
	@Inject protected extension TraceCode
	@Inject protected extension ShadowEventExtensions
	
	def generateEventDefinition(Event event, GeneratorEntry entry, InterfaceScope scope) '''
		«event.fieldDeclaration»

		«IF event.direction == Direction::IN»
		
		«event.generateInEventDefinition»
		«ENDIF»
		«IF event.direction == Direction::OUT»
		
		«event.generateOutEventDefinition(entry, scope)»
		«ENDIF»
	'''
	
	def fieldDeclaration(Event event) {
		'''
		private boolean «event.identifier»;
		«IF event.hasValue»
		
		private «event.typeSpecifier.targetLanguageName» «event.valueProperty»;
		«ENDIF»
		'''
	}
			
	def generateOutEventDefinition(Event event, GeneratorEntry entry, InterfaceScope scope) '''
		«outEventRaiser(event)»
		«IF useOutEventGetters»
			public boolean isRaised«event.name.asName»() {
				«sync(event.syncObject, '''return «event.identifier»;''')»
			}
			
			«IF event.hasValue»
				
				«eventValueGetter(event)»
			«ENDIF»
		«ENDIF»
		«IF useOutEventObservables»
		
		«eventObservableField(event)»
		
		«eventObservableGetter(event)»
		«ENDIF»
	'''

	def generateInEventDefinition(Event event) '''
		«inEventRaiser(event)»
		«IF event.hasValue»
			«eventValueGetter(event)»
		«ENDIF»
	'''
	
	def eventValueGetter(Event it) {
		'''
		«eventValueGetterVisibility» «typeSpecifier.targetLanguageName» get«name.asName»Value() {
			«sync(syncObject, '''
			«getIllegalAccessValidation»
			return «valueProperty»;
			''')»
		}
		'''
	}
	
	protected def eventObservableField(Event event) {
		'''
		private Observable<«event.eventType»> «event.observableName» = new Observable<«event.eventType»>();
		'''
	}
	
	protected def eventObservableGetter(Event event) {
		'''
		public Observable<«event.eventType»> «event.observableGetterName»() {
			return «event.observableName»;
		}
		'''
	}
	
	protected def eventValueGetterVisibility(Event it) {
		switch(event.direction) {
			case IN: {
				"protected"
			}
			case LOCAL: {
				"protected"
			}
			case OUT: {
				"public"
			}
			
		}
	}
	
	protected def internalEventRaiser(Event it) {
		eventRaiser
	}
	
	protected def inEventRaiser(Event it) {
		eventRaiser
	}
	
	protected def outEventRaiser(Event it) {
		eventRaiser
	}
	
	protected def eventRaiserVisibility(Event it) {
		switch (direction) {
			case IN: if(scope instanceof InternalScope) "protected" else "public"
			case OUT: "protected"
			case LOCAL: "protected"
		}
	}
	
	protected def eventRaiser(Event it) {
		'''
			«IF hasValue»
				«eventRaiserVisibility» void raise«name.asName»(«typeSpecifier.targetLanguageName» value) {
			«ELSE»
				«eventRaiserVisibility» void raise«name.asName»() {
			«ENDIF»
				«sync(syncObject, '''
				«IF hasValue»
					«valueProperty» = value;
				«ENDIF»
				«identifier» = true;
				«IF needsObservable»
					«observableName».next(«IF hasValue»value«ELSE»null«ENDIF»);
				«ENDIF»
				«IF isOutEvent && getLocalOutEvent !== null»
					«contextInstance»raise«getLocalOutEvent().name.asName»(«IF getLocalOutEvent().hasValue»value«ENDIF»);
				«ENDIF»
				«eventTrace»
				''')»
			}
		''' 
	}

	
	protected def eventTrace(Event it) '''
		«IF scope.isNamedScope»
			«it.traceCodeFromNamedScope(if(hasValue) valueProperty else 'null')»
		«ELSE»
			«it.traceCode(if(hasValue) valueProperty else 'null')»
		«ENDIF»
	'''


	def getIllegalAccessValidation(Event it) '''
		if (! «name.asEscapedIdentifier» ) 
			throw new IllegalStateException("Illegal event value access. Event «name.asEscapedName» is not raised!");
	'''
	
	def nextEvent(ExecutionFlow it) {
		// nothing to do for cycle based statecharts
	}
	
	override eventClearCode(ExecutionFlow flow, Expression event) '''«event.code» = false;'''
	
	override eventMoveCode(ExecutionFlow flow, Expression source, Expression target) '''
		«target.code» = «source.code»;
		«IF source.event.hasValue»«target._meta(target.event.valueFeature).code» = «source._meta(source.event.valueFeature).code»;«ENDIF»
		«source.code» = false;
	'''
	
	override eventNextCode(ExecutionFlow flow) {
		throw new UnsupportedOperationException("Something went wrong - generating 'eventNext' not supported for cycle based statecharts.")
	}
	
	override getNextEventCode(ExecutionFlow it) {
		'''nextEvent()'''
	}
	
	protected def contextInstance(EObject it) {
		if (isInNamedInterface) parentStatemachineInstance + "." else ""
	}
	
}