/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.Property
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.JavaNamingService
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry

import static org.eclipse.xtext.util.Strings.*
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

@Singleton
class FieldDeclarationGenerator {
	@Inject protected extension Naming
	@Inject protected extension JavaNamingService
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension SExecExtensions
	@Inject protected extension GenmodelEntries
	@Inject protected extension VariableCode
	@Inject protected extension EventCode
	@Inject protected extension TraceCode
	@Inject protected extension StatechartAnnotations
	
	def internalEventFields(ExecutionFlow flow) '''
		«FOR event : flow.internalScopeEvents»
		«event.fieldDeclaration»
		«ENDFOR»
	'''
	
	def createFieldDeclarations(ExecutionFlow flow, GeneratorEntry entry) '''
		«FOR scope : flow.namedInterfaceScopes»
			protected «scope.interfaceTypeName» «scope.interfaceVariableName»;
			
		«ENDFOR»
		«statesEnum(flow)»

		«stateVectors(flow)»
		
		«IF entry.tracingGeneric»
		«flow.featuresEnum»
		
		«entry.traceObservable(flow)»
		
		«ENDIF»
		«IF entry.tracingUsed»
		«entry.tracingFields»
		
		«ENDIF»
		«IF flow.timed»
		«flow.timingFields»
		
		«ENDIF»
		«flow.internalEventFields»
		«FOR v : flow.internalScopeVariables SEPARATOR newLine AFTER newLine»
			«v.code»
			
		«ENDFOR»
		«FOR v : flow.features.filter(Property)»
			«v.code»
		«ENDFOR»
	'''
	
	
	
	
	def featuresEnum(ExecutionFlow it) {
		val featureEnumeratorNames = allEventAndVariables.map[ f | '''«f.tracefeatureEnumMemberName»'''].toList
		featureEnumeratorNames.add(0, '''NO_FEATURE''')
			
		'''
			/** Enumeration of all features of the statechart */ 
			public enum Feature
			{
				«FOR feature : featureEnumeratorNames SEPARATOR ","»
					«feature»
				«ENDFOR»
			};
		'''	
	}
	
	protected def statesEnum(ExecutionFlow it) '''
		public enum State {
			«FOR state : states»
				«state.stateName»,
			«ENDFOR»
			«nullStateName»
		};
	'''
	
	protected def stateVectors(ExecutionFlow it) '''
		«IF hasHistory»
			private State[] historyVector = new State[«historyVector.size»];
		«ENDIF»
		private final State[] stateVector = new State[«stateVector.size»];
	'''
	
	protected def timingFields(ExecutionFlow it) '''
		private «iTimerService» «timerServiceInstance»;
		
		private final boolean[] timeEvents = new boolean[«flow.timeEvents.size»];
	'''
	
	protected def tracingFields(GeneratorEntry it) '''
		private List <«tracingListener»<State>> «traceInstances» = new LinkedList <«tracingListener»<State>>();
	'''

	protected def traceObservable(GeneratorEntry it, ExecutionFlow flow) '''
		protected Observable<«traceEventClass»<«flow.statemachineClassName», State, Feature>> trace = new Observable<«traceEventClass»<«flow.statemachineClassName», State, Feature>>();
	'''

}